package com.bcxin.platform.domain.system;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.List;

/**
 * 地区对象 sys_region
 * 
 * @author task
 * @date 2021-01-22
 */
@Data
public class SysRegion extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 区域ID */
    private Long regionId;

    /** 区域名称 */
    @Excel(name = "区域名称")
    private String regionName;

    /** 区域全称 */
    @Excel(name = "区域全称")
    private String regionFullName;

    /** 区域级别 */
    @Excel(name = "区域级别")
    private String regionLevel;

    /** 排序 */
    @Excel(name = "排序")
    private Integer seq;

    /** 地区首字母 */
    @Excel(name = "地区首字母")
    private String firstLetter;

    /** 是否激活市场 */
    @Excel(name = "是否激活市场")
    private String isActiveMarket;

    /** 邮政编码 */
    @Excel(name = "邮政编码")
    private String zipCode;

    /** 上级区域ID */
    @Excel(name = "上级区域ID")
    private Long parentRegionId;

    /**
     * 子节点
     */
    private List<SysRegion> s;
}
