package com.bcxin.platform.service.temporary;

import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.temporary.ComProject;
import com.bcxin.platform.domain.temporary.ComProjectPer;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.temporary.ComProjectMapper;
import com.bcxin.platform.mapper.temporary.ComProjectPerMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * <b> 临保项目业务 </b>
 * @author ZXF
 * @create 2025/08/06 0006 10:56
 * @version
 * @注意事项 </b>
 */
@Service
@Transactional("transactionManager")
public class ComProjectServiceImpl implements ComProjectService {

    @Resource
    private ComProjectMapper comProjectMapper;

    @Resource
    private ComProjectPerMapper comProjectPerMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;

    @Resource
    private IdWorker idWorker;

    @Override
    public Result save(ComProject comProject) {

        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectComBaseInfoByTlkId(comProject.getTlkComId());
        if(comBaseInfo != null){
            comProject.setComId(comBaseInfo.getComId());
        }
        comProjectMapper.insert(comProject);
        return Result.success("添加成功");
    }

    @Override
    public Result update(ComProject comProject) {
        ComProject cp = comProjectMapper.getItemsBytlkProjectId(comProject.getTlkProjectId());
        cp.setProjectName(comProject.getProjectName());
        cp.setProjectType(comProject.getProjectType());
        cp.setAddress(comProject.getAddress());
        cp.setCoordinate(comProject.getCoordinate());
        cp.setStartTime(comProject.getStartTime());
        cp.setEndTime(comProject.getEndTime());
        cp.setUpdateTime(new Date());
        comProjectMapper.update(comProject);
        return Result.success("修改成功");
    }

    @Override
    public Result delete(String tlkProjectId) {
        comProjectMapper.delete(tlkProjectId);
        return Result.success("删除成功");
    }

    @Override
    public Result batchDelete(String[] tlkProjectPerIds) {
        comProjectPerMapper.batchDelete(tlkProjectPerIds);
        return Result.success("删除成功");
    }

    @Override
    public Result getProjectListByComId(Long comId) {
        List<ComProject> list = comProjectMapper.findComProjectByComId(comId);
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    @Override
    public Result savePer(Collection<ComProjectPer> comProjectPerList) {
        for (ComProjectPer per : comProjectPerList){
            comProjectPerMapper.insert(per);
        }
        return Result.success("添加成功");
    }

}