package com.bcxin.platform.service.company;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.dto.company.ComDepartTreeDto;
import com.bcxin.platform.dto.company.OrgTreeDto;

import java.util.List;

/**
 * 部门Service接口
 * 
 * @author task
 * @date 2021-04-09
 */
public interface ComDepartService{

    /**
     * 查询部门
     * 
     * @param departId 部门ID
     * @return 部门
     */
    ComDepart selectComDepartById(Long departId);

    /**
     * 查询部门列表
     * 
     * @param comDepart 部门
     * @return 部门集合
     */
    List<ComDepart> selectComDepartList(ComDepart comDepart);

    /**
     * 新增部门
     * 
     * @param comDepart 部门
     * @return 结果
     */
    int insertComDepart(ComDepart comDepart);

    /**
     * 修改部门
     * 
     * @param comDepart 部门
     * @return 结果
     */
    int updateComDepart(ComDepart comDepart);

    void saveBatch(List<ComDepart> list);

    /**
     * 批量删除部门
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteComDepartByIds(String ids);

    /**
     * 删除部门信息
     * 
     * @param departId 部门ID
     * @return 结果
     */
    int deleteComDepartById(Long departId);

    int editBatch(String tklComId, List<ComDepart> list);

    /**
     * 人事模块-组织架构部门树（新）
     * @param comDepartDto
     * @auth llc
     * @date 2019-07-16
     * @return
     */
    Result getDepartTree(ComDepartDto comDepartDto);

    List<OrgTreeDto> getDepartChild(String parentDepartId, List<OrgTreeDto> departList);

    /**
     * 获取公司所有部门树形接口(无数据权限)
     *
     * @param comDepart
     * @return
     */
    Result getTreeDepartNotDataAuth(ComDepartDto comDepart);

    /**
     * 获取公司所有部门树形接口
     *
     * @param comDepart
     * @return
     */
    Result getTreeDepart(ComDepartDto comDepart);

    List<ComDepartTreeDto> getTreeDepartForAttend(ComDepartDto comDepartDto);

    /**
     * 查询部门
     *
     * @param tlkDepartId v5部门ID
     * @return 部门
     */
    ComDepart selectComDepartByTlkId(String tlkDepartId);

    List<ComDepart> selectListByComId(Long comId);
}
