package com.bcxin.platform.service.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.core.domain.entity.SysDictData;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.BusinessLog;
import com.bcxin.platform.domain.company.ConfigIndustryDict;
import com.bcxin.platform.domain.log.SysSmsLog;
import com.bcxin.platform.domain.system.SysRegion;
import com.bcxin.platform.dto.ConfigDictDto;
import com.bcxin.platform.dto.grant.ConfigBankOutletsDTO;
import com.bcxin.platform.mapper.common.ConfigDictMapper;
import com.bcxin.platform.mapper.common.ConfigIndustryDictMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.grant.ConfigBankOutletsMapper;
import com.bcxin.platform.mapper.log.SysSmsLogMapper;
import com.bcxin.platform.mapper.system.SysConfigMapper;
import com.bcxin.platform.mapper.system.SysRegionMapper;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.service.system.ISysConfigService;
import com.bcxin.platform.service.system.ISysDictTypeService;
import com.bcxin.platform.util.HttpUtils;
import com.bcxin.platform.util.constants.*;
import com.bcxin.platform.util.http.HuaWeiSmsContent;
import com.bcxin.platform.util.http.SMSUtil;
import com.bcxin.platform.util.huawei.HttpBuildUtil;
import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 公用查询方法
 *
 * @author zhangye
 * @since 2018-02-26 13:42:27
 */
@Service
@Transactional("transactionManager")
public class CommonServiceImpl implements CommonService {
    private static Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private CommonService commonService;

    @Autowired
    private SysRegionMapper sysRegionMapper;

    @Resource
    private ISysConfigService sysConfigService;

    @Autowired
    private SysConfigMapper configMapper;

    @Resource
    private ConfigDictMapper configDictMapper;

    @Resource
    private ConfigIndustryDictMapper configIndustryDictMapper;

    @Resource
    private RedisUtil redisUtil;

    @Resource
    private ISysDictTypeService sysDictTypeService;

    private final static Integer PHONE_LENGTH = 11;

    @Resource
    private SysSmsLogMapper sysSmsLogMapper;

    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;

    @Resource
    private ConfigBankOutletsMapper configBankOutletsMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 得到库表的配置信息
     *
     * @param key
     * @return value
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/1/2 15:46
     */
    @Override
    public String getSystemConfig(String key) { // hash
//        if(key.equals("PAYMENT_PLATFORM_URL")){
//            return "http://192.168.40.86:8080/";
//        }
        return sysConfigService.selectConfigByKey(key);
    }

    /**
     * <b> 字符串存redis </b>
     * @author ZXF
     * @create 2019/10/11 0011 16:56
     * @version
     * @注意事项 </b>
     */
    @Override
    public void setConditions(String key, String value) {
        key = PublicConst.REDIS_HEAD + "Conditions:" + key;
        stringRedisTemplate.opsForValue().set(key, value, PublicConst.CONDITIONS_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getConditions(String key) {
        String result = stringRedisTemplate.opsForValue().get(PublicConst.REDIS_HEAD + "Conditions:" + key);
        return result;
    }

    /**
     * 发送消息（调用罗总发送消息方法）
     *
     * @param tilte       标题
     * @param content     内容
     * @param messageType 消息类型
     * @param ids         接收人id，多个用,隔开
     * @apiNote 作者 zhongjianhui
     * @since 创建于 2018年4月23日 10:00:36
     */
    @Override
    public void sendMessageToApp(String tilte, String content, String messageType, String ids, Long comId, Long id) {
        new Thread(() -> {
            try {
                Map params = CollUtil.newHashMap();
                params.put("title", tilte);
                params.put("content", content);
                params.put("messageType", messageType);
                params.put("comId", comId);
                params.put("comTaskId", id);
                params.put("objectId", id);
                // 接收人id，多个用,隔开
                params.put("ids", ids);
                // SAAS平台标识
                params.put("platId", "10");
                // 发送方式（1：sms ，2：email ， 3：app）
                params.put("way", "3");
                String result = HttpUtil.post(this.getSystemConfig("SYS_PIC_HTTP_ADDR") + "/public/message/send-message", params);
                System.out.println(result);
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }

    /**
     * 添加业务日志
     *
     * @param businessLog
     * @return value
     * @apiNote 作者 zhangjianhua
     * @since 创建于 2018/3/1 15:46
     */
    @Override
    public void BunissLogDemo(BusinessLog businessLog) throws V5BusinessException {

        // 业务日志
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("businessType", businessLog.getBusinessType());// 业务类型
        paramMap.put("currentApprovalLevel", businessLog.getCurrentApprovalLevel()); // 当前复核级次
        paramMap.put("partyType", businessLog.getPartyType()); // 当事人类型
        paramMap.put("partyId", businessLog.getPartyId()); // 当事人ID
        paramMap.put("comId", businessLog.getComId()); // 企业ID
        paramMap.put("businessHandlStatus", businessLog.getBusinessHandlStatus()); // 业务办理状态
        paramMap.put("handlePerId", businessLog.getHandlePerId()); // 业务经办人ID
        try {
            String result = HttpUtil.post(commonService.getSystemConfig(CommonConst.YWRZ_URL), paramMap);
            JSONObject jsonBack = JSONUtil.parseObj(result);
            String retType = jsonBack.get("retType").toString();
            if (!"0".equals(retType)) {
                throw new V5BusinessException(Result.BUSINESS_ERROR, "新增业务日志失败");
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new V5BusinessException(e.toString(), "新增业务日志失败");
        }
    }

    /**
     * 单个地区代码翻译
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/1/16 15:47
     */
    @Override
    public Result getRegionById(SysRegion sysRegion) {
        SysRegion rec = sysRegionMapper.selectSysRegionById(sysRegion.getRegionId());
        return Result.success(Result.SUCCESS_QUERY_MSG, rec);
    }

    /**
     * 根据父节点地区代码，查询出所有子节点地区信息列表
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/1/16 15:47
     */
    @Override
    public Result getRegionByParentId(SysRegion sysRegion) {
        List<SysRegion> list = sysRegionMapper.selectByParentId(sysRegion.getParentRegionId());
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    /**
     * 根据级别查询出省市县的数据列表
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/1/16 15:48
     */
    @Override
    public Result getRegionByLevel(SysRegion sysRegion) {
        List<SysRegion> list = sysRegionMapper.selectByLevel(Integer.valueOf(sysRegion.getRegionLevel()));
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    /**
     * 返回map对象，key是地区编码，val是地区对象
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/1/16 15:48
     */
    @Override
    public Result getRegionAsObj() {
        String redisKey = redisUtil.REDIS_PREFIX_KEY + ":RegionConfig";
        Map<String, Object> m = Maps.newHashMap();
        List<SysRegion> list;
        if (!stringRedisTemplate.hasKey(redisKey)) { // 第一次加载
            list = sysRegionMapper.selectAll();
            stringRedisTemplate.opsForValue().set(redisKey, JSON.toJSONString(list), PublicConst.ONE_WEEK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        } else { // 从缓存读取
            list = JSON.parseArray(stringRedisTemplate.opsForValue().get(redisKey), SysRegion.class);
        }
        for (SysRegion rec : list) {
            m.put(String.valueOf(rec.getRegionId()), rec);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, m);
    }

    /**
     * <b> 返回递归省市县，400k左右，走缓存 </b>
     * @author ZXF
     * @create 2021/06/25 0025 11:14
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result getRegions() {
//        String redisKey = redisUtil.REDIS_PREFIX_KEY + ":RegionConfigTree";
        List<SysRegion> r = new ArrayList<SysRegion>();
//        if (!stringRedisTemplate.hasKey(redisKey)) { // 第一次加载
            List<SysRegion> l = sysRegionMapper.selectByLevel(1); // 加载所有省份
            List<SysRegion> list = sysRegionMapper.selectAll();
            for (SysRegion s : l) {
                r.add(getChild(s, list));
            }
//            stringRedisTemplate.opsForValue().set(redisKey, JSON.toJSONString(r), PublicConst.ONE_WEEK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
//        } else {
//            r = JSON.parseObject(stringRedisTemplate.opsForValue().get(redisKey), List.class);
//        }
        return Result.success(Result.SUCCESS_QUERY_MSG, r);
    }

    /**
     * <b> 递归查找子节点 </b>
     * @author ZXF
     * @create 2021/06/25 0025 11:14
     * @version
     * @注意事项 </b>
     */
    private SysRegion getChild(SysRegion root, List<SysRegion> list) {
        List<SysRegion> l = new ArrayList<SysRegion>();
        for (SysRegion sr : list) {
            if (String.valueOf(sr.getParentRegionId()).equals(String.valueOf(root.getRegionId()))) {
                SysRegion sr2 = getChild(sr, list);
                l.add(sr2);
            }
        }
        root.setS(l);
        return root;
    }


    /**
     * @Author: wangcy
     * @Description:通过ID查询 多个地区
     * @Date: 2018/01/23 0023 16:12
     */
    @Override
    public Result getRegionList(String sysRegionList) {
        List<SysRegion> list = new ArrayList<>();
        if (StringUtils.isNotEmpty(sysRegionList)) {
            for (String regionid : sysRegionList.split(",")) {
                if (!StringUtils.isNumeric(regionid)) {
                    return Result.fail("地址异常", regionid);
                }
                SysRegion rec = sysRegionMapper.selectSysRegionById(Long.valueOf(regionid));
                if (rec == null) {
                    return Result.fail("地址不存在", regionid);
                }
                list.add(rec);
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    /**
     * 根据地区名称获取地区对象
     *
     * @param regionName
     * @return
     */
    @Override
    public Result getRegionByName(String regionName) {
        return Result.success(Result.SUCCESS_QUERY_MSG, sysRegionMapper.selectByName(regionName));
    }

    @Override
    public String getConfigBank(String key) {
        Result result = getConfigDictById("bankCode");
        Map<String,List<ConfigDictDto>> dictData = (Map)result.getData();
        for (ConfigDictDto sysDictData : dictData.get("bankCode")) {
            if(sysDictData.getCodeValue().equals(key)){
                return sysDictData.getLabel();
            }
        }
        return null;
    }

    /**
     * 返回银行编码表
     * 由于redisKey对应的value存在变动手动删除不方便
     *
     * @author llc
     * @date 2019-06-24
     */
    @Override
    public Result getConfigBankList() {
        return Result.success(Result.SUCCESS_QUERY_MSG, getConfigDictById("bankCode").getData());
    }

    /**
     * 字典查询，从缓存里面拿
     *
     * @param codeTypes
     * @auth llc
     * @update by llc 2019-06-26
     */
    @Override
    public Result getConfigDictById(String codeTypes) {
        List<String> strs = StrSpliter.split(codeTypes, CommonConst.COMMA, 0, true, true);
        Map retrunMap = Maps.newHashMap();
        if(strs.size()>0) {
            for (String codeType : strs) {
                List<ConfigDictDto> configDictList = new ArrayList<>();
                List<SysDictData> dictList = sysDictTypeService.selectDictDataByType(codeType);
                ConfigDictDto dictDto = null;
                for (SysDictData dictData : dictList) {
                    dictDto = new ConfigDictDto();
                    dictDto.setCodeType(dictData.getDictType());
                    dictDto.setCodeValue(dictData.getDictValue());
                    dictDto.setLabel(dictData.getDictLabel());
                    configDictList.add(dictDto);

                }
                retrunMap.put(codeType, configDictList);
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, retrunMap);
    }


    /**
     * 行业字典查询，通过企业ID 1.如果账号有关联企业，根据企业信息中行业、机构类别获取 2.如果账号未关联企业，根据页面传的行业、机构值获取
     *
     * @param cid
     * @apiNote 作者 zxf
     * @since 创建于 2018/09/20 15:18
     */
    @Override
    public Result getConfigIndustryDictByComId(ConfigIndustryDict cid) {
        if (StringUtils.isNotEmpty(cid.getCodeType())) {
            List<Map> listMap = null;
            if (cid.getComId() != null) {
                listMap = configIndustryDictMapper.getConfigIndustryDictByType(cid.getCodeType(), cid.getComId());
            } else {
                if (StringUtils.isNotEmpty(cid.getIndustryType()) && StringUtils.isNotEmpty(cid.getInstitutionType())) {
                    listMap = configIndustryDictMapper.getConfigIndustryDictByThisType(cid.getCodeType(),
                            cid.getIndustryType(), cid.getInstitutionType());
                } else {
                    return Result.fail("行业、机构不能为空");
                }
            }
            return Result.success(Result.SUCCESS_QUERY_MSG, listMap);
        }
        return Result.fail("从业key不能为空");
    }

    /**
     * 机构字典查询，通过行业值
     *
     * @param industryType 行业
     * @apiNote 作者 zxf
     * @since 创建于 2018/09/20 15:18
     */
    @Override
    public Result getInstitutionTypeByIndustryType(String industryType) {
        if (StringUtils.isNotEmpty(industryType)) {
            List<Map> listMap = configIndustryDictMapper.getInstitutionTypeByIndustryType(industryType);
            return Result.success(Result.SUCCESS_QUERY_MSG, listMap);
        }
        return Result.fail("行业不能为空");
    }

    /**
     * 获得保障项目列表
     *
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/3/2 16:36
     */
    @Override
    public Result getInsProjects() {
        List<Map> list = configDictMapper.getInsProjects();
        return Result.success(Result.SUCCESS_QUERY_MSG, list);
    }

    /**
     * 分发服务配置表缓存
     * @param key
     * @author llc
     * @date 2021-03-13
     */
    @Override
    public Map<String,String> getConfigBdp(String key) {
        String redisKey = redisUtil.REDIS_PREFIX_KEY + ":ConfigBdp";
        Map<String, Object> cacheMap = Maps.newHashMap();
        Object value = null;
        if (!stringRedisTemplate.hasKey(redisKey)) {
            // 查询数据库配置表，存为一个map，放入缓存，设置超时30分钟
            List<Map<String, Object>> list = configMapper.getConfigBdp();
            for (Map<String, Object> m : list) {
                cacheMap.put(String.valueOf(m.get("code")), com.alibaba.fastjson.JSONObject.toJSONString(m));
            }
            stringRedisTemplate.opsForHash().putAll(redisKey, cacheMap);
            stringRedisTemplate.expire(redisKey,PublicConst.ONE_WEEK_TIMEOUT_MILLISECONDS,TimeUnit.MILLISECONDS);
            value = cacheMap.get(key);
        } else {
            value = stringRedisTemplate.opsForHash().get(redisKey, key);
        }
        if(value == null){
            return null;
        }

        return com.alibaba.fastjson.JSONObject.parseObject(String.valueOf(value),Map.class);
    }

    /**
     * 通过接口删除redisKey方便下次加载
     * 由于redisKey对应的value存在变动手动删除不方便
     *
     * @author llc
     * @date 2019-05-10
     */
    @Override
    public Result deleteRedisByKey(String key) {
        String redisKey = redisUtil.REDIS_PREFIX_KEY + ":" + key;
        /*** 如果存在key就删除 ***/
        if (stringRedisTemplate.hasKey(redisKey)) {
            stringRedisTemplate.delete(redisKey);
        }

        return Result.success(Result.SUCCESS_QUERY_MSG);
    }

    @Override
    public String sendCode(String mobile){
        if (StringUtils.isEmpty(mobile)) {
            throw new V5BusinessException(Result.ERROR,"手机号码不能为空");
        }
        String channel = null;
        /*针对旧数据，用户名为身份证的，无法发送短信 */
        if (mobile.length() != PHONE_LENGTH) {
            /* 重新从数据库中查找对应手机号 */
            String newMobile = perBaseInfoMapper.getMobilePhoneByUserName(mobile);
            if (StringUtil.isEmpty(newMobile)) {
                throw new V5BusinessException(Result.ERROR,"手机号码不能为空");
            }
            mobile = newMobile;
        }
        int phoneCount = getSMSPhoneCount(mobile);
        String msgMaxCount = sysConfigService.selectConfigByKey("MSG_ONEDAY_MAXCOUNT");
        if (phoneCount >= Integer.parseInt(msgMaxCount)) {
            throw new V5BusinessException(Result.ERROR,"已超出每日验证码发送限额，手机验证码发送失败");
        }
        // 生成随机6位数
        String random = RandomUtil.randomNumbers(6);
        /* 如果不是生产环境，默认激活短信验证码为 123456，by罗鹏 */
        String platform = sysConfigService.selectConfigByKey("PLATFORM_SIGN");
        if (!Objects.equals(platform, Constants.ENVI_PROD)) {
            random = CommonConst.DEFAULT_VALIDATE_CODE;
        }
        // 发送短信
        String message = SMSConst.VERIFICATION_CODE.replace("{random}",random);
        // 短信发送开关状态1为可以发送
        String msgOpenState = sysConfigService.selectConfigByKey("MSG_OPEN_STATE");
        if (StringUtils.isNotEmpty(msgOpenState)) {
            setPhoneAuthCode(mobile, random);// 缓存到redis中
            // 发送短信
            //手机短信日志存储
            sysSmsLogMapper.insert(new SysSmsLog(idWorker.nextId(), new Date(), mobile, message));
            if (CommonConst.Y.equals(msgOpenState)) {
                HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
                huaWeiSmsContent.setPlatform(Constants.ENVI);
                huaWeiSmsContent.setSmsCode(DictConst.SMSCODE_P01);
                huaWeiSmsContent.setMobile(mobile);
                huaWeiSmsContent.setChannel(channel);
                huaWeiSmsContent.setParams(JSON.toJSONString(new String[]{random}));
                SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);
                setSMSPhoneCount(mobile,phoneCount);
            }
        }
        return random;
    }

    @Override
    public Result sendVerificationCode(String mobile) {
        sendCode(mobile);
        return Result.success("短信发送成功");
    }

    @Override
    public Result verificationCode(String mobile, String code) {
        if (StringUtils.isEmpty(mobile)) {
            throw new V5BusinessException(Result.ERROR, "手机号码不能为空");
        }
        if (StringUtils.isEmpty(code)) {
            throw new V5BusinessException(Result.ERROR, "验证号码不能为空");
        }
        /*针对旧数据，用户名为身份证的，无法发送短信 */
        if (mobile.length() != PHONE_LENGTH) {
            /* 重新从数据库中查找对应手机号 */
            String newMobile = perBaseInfoMapper.getMobilePhoneByUserName(mobile);
            if (StringUtil.isEmpty(newMobile)) {
                return Result.fail("手机号码不能为空", mobile);
            }
            mobile = newMobile;
        }
        String verify = getPhoneAuthCode(mobile, code);
        if (StringUtils.isEmpty(verify)) {
            throw new V5BusinessException(Result.ERROR, "您输入的验证码超时或者不正确，请重新获取");
        } else {
            if (verify.equals(code)) {
                return Result.success("", null);
            } else {
                throw new V5BusinessException(Result.ERROR, "您输入的验证码不正确");
            }
        }
    }

    /**
     * 批量发送短信信息
     */
    @Override
    public Result sendBatchSMS(List<Map<String, String>> list, String smsCode) {
        new Thread(() -> {
            if (list != null && list.size() > 0) {
                // 短信发送开关状态1为可以发送
                String msgOpenState = commonService.getSystemConfig("MSG_OPEN_STATE");
                if (StringUtils.isNotEmpty(msgOpenState)) {
                    // 发送短信
                    try {
                        for (Map<String, String> map : list) {
                            String mobile = map.get("mobile");
                            String content = map.get("content");
                            String params = map.get("params");
                            if (StringUtils.isEmpty(mobile)) {
                                logger.error("手机号码不能为空");
                                continue;
                            }
                            if (StringUtils.isEmpty(content)) {
                                logger.error("发送内容不能为空");
                                continue;
                            }
                            String channel = map.get("channel");
                            //手机短信日志存储
                            sysSmsLogMapper.insert(new SysSmsLog(idWorker.nextId(), new Date(), mobile, content));
                            if (CommonConst.Y.equals(msgOpenState)) {
                                HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
                                huaWeiSmsContent.setPlatform(Constants.ENVI);
                                huaWeiSmsContent.setSmsCode(smsCode);
                                huaWeiSmsContent.setMobile(mobile);
                                huaWeiSmsContent.setParams(params);
                                huaWeiSmsContent.setChannel(channel);
                                SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);
                            }
                        }
                    } catch (Exception e) {
                        logger.error(e.getMessage());
                    }

                }
            }
        }).start();
        return Result.success("短信发送成功");
    }

    @Override
    public void sendSMS(HuaWeiSmsContent huaWeiSmsContent) {
        // 短信发送开关状态1为可以发送
        String msgOpenState = commonService.getSystemConfig("MSG_OPEN_STATE");
        if (CommonConst.Y.equals(msgOpenState)) {
            SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);
        }
    }

    /**
     * 记录手机号发送验证码次数
     */
    private void setSMSPhoneCount(String key, int count) {
        if (count == 0) {
            stringRedisTemplate.opsForValue().set(PublicConst.REDIS_HEAD + "PhoneCount:" + key, (count + 1) + "",
                    PublicConst.ONE_DAY_TIMEOUT_MILLISECONDS, TimeUnit.MILLISECONDS);
        } else {
            stringRedisTemplate.opsForValue().set(PublicConst.REDIS_HEAD + "PhoneCount:" + key, (count + 1) + "", 0);
        }
    }

    /**
     * 记录手机号发送验证码次数
     */
    private int getSMSPhoneCount(String key) {
        String count = stringRedisTemplate.opsForValue().get(PublicConst.REDIS_HEAD + "PhoneCount:" + key);
        if (StringUtils.isEmpty(count)) {
            return 0;
        }
        return Integer.parseInt(count);
    }

    /**
     * 获取手机验证码
     *
     * @param key
     * @return
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/1/2 16:17
     */
    private String getPhoneAuthCode(String key, String value) {

        /**** 为了测试方便，验证码固定为888888则跳过校验 ****/
        if (value.equalsIgnoreCase("888888")) {
            return value;
        }
        String result = stringRedisTemplate.opsForValue().get(PublicConst.REDIS_HEAD + "PhoneAuthCode:" + key + value);
        return result;
    }
    /**
     * 设置手机验证码缓存
     *
     * @param key
     * @param value
     * @apiNote 作者 陈堂君
     * @since 创建于 2018/1/2 16:16
     */
    private void setPhoneAuthCode(String key, String value) {
        // 使用冒号分隔，客户端工具可以形成命名空间折叠方便阅读。
        stringRedisTemplate.opsForValue().set(PublicConst.REDIS_HEAD + "PhoneAuthCode:" + key + value, value,
                PublicConst.PHONE_AUTH_CODE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    /**
     * 发送审批消息（调用罗总发送消息方法）
     *
     * @param tilte
     *            标题
     * @param content
     *            内容
     * @param messageType
     *            消息类型
     * @param emails
     *            接收人id，多个用,隔开
     * @author ZXF
     * @create 2018/11/06 0006 17:27
     * @version
     * @注意事项 </b>
     */
    @Override
    public void sendEmailMessage(String tilte, String content, String messageType, String emails) {
        new Thread(() -> {
            try {
                Map params = CollUtil.newHashMap();
                params.put("title", tilte);
                params.put("content", content);
                params.put("messageType", messageType);
                // 接收人id，多个用,隔开
                params.put("emails", emails);
                // SAAS平台标识
                params.put("platId", "10");
                String result = HttpUtils.doPost(
                        sysConfigService.selectConfigByKey(CommonConst.SYS_PIC_HTTP_ADDR) + "/public/message/send-email-message", params);
                logger.info(result);
            } catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }


    /**
     * 获取企业管理员华为云会议acessToken
     *
     * @param userName
     * @param passWord
     * @param comId
     * @return accessToken
     * @auth llc
     * @date 2019-12-18
     */
    @Override
    public String getComManageHuaweiMeetAccessToken(String userName, String passWord, String comId) {
        String redisKey = PublicConst.REDIS_HEAD + "huaweiMeetCom" + comId;
        String accessToken = "";
        if (!stringRedisTemplate.hasKey(redisKey)) {
            String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
            Map<String, Object> map = new HashMap<>();
            map.put("account", userName);
            map.put("clientType", 0);
            map.put("createTokenType", 0);
            String url = HuaweiMeetConst.GATEWAY_URL + HuaweiMeetConst.GET_ACCESSTOKEN;
            Map<String, String> headMap = new HashMap<>();
            headMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(map), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            if(response.getHttpCode()==HuaweiMeetConst.HUAWEI_SUCCESS_CODE){
                Map<String, Object> resultMap = JSON.parseObject(response.getEntity().toString(), Map.class);
                if(resultMap != null){
                    accessToken = resultMap.get("accessToken").toString();
                    String expires_in = resultMap.get("validPeriod").toString();
                    /*** 华为云token失效时间- 一小时 ***/
                    Long expiresTime = Long.parseLong(expires_in) - 3600L;
                    if (expiresTime > 0) {
                        stringRedisTemplate.opsForValue().set(redisKey, accessToken, expiresTime, TimeUnit.SECONDS);
                    }
                }
            }
        } else {
            accessToken = stringRedisTemplate.opsForValue().get(redisKey);
            logger.info("从缓存中拿accessToken:" + accessToken);
        }
        return accessToken;
    }

    /**
     * <b> 获取IAM用户Token（使用密码） </b>
     * @param comId
     * @author ZXF
     * @create 2020/05/27 0027 14:46
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getHuaweiMeetIAMTokens(Long comId) {
        String redisKey = PublicConst.REDIS_HEAD + "huaweiMeetIAM" + comId;
        String accessToken = "";
        if (!stringRedisTemplate.hasKey(redisKey)) {
            String url = HuaweiMeetConst.GATEWAY_IAM_TOKENS_URL;
            String param = HuaweiMeetConst.REQUEST_IAM_TOKEN_MESSAGE
                    .replace("IAMUser",getSystemConfig("MEET_LOGIN_USER"))
                    .replace("IAMproject",getSystemConfig("MEET_ACTUATING_RANGE_4"))
                    .replace("IAMDomain",getSystemConfig("MEET_LOGIN_USER"))
                    .replace("IAMPassword",getSystemConfig("MEET_LOGIN_PWD"));
            accessToken = com.bcxin.platform.util.huawei.HttpUtil.postGetToken(url,param);
            if(StringUtils.isNotEmpty(accessToken)){
                /*** 华为云token失效时间- 一天 ***/
                stringRedisTemplate.opsForValue().set(redisKey, accessToken, PublicConst.ONE_DAY_TIMEOUT_MILLISECONDS, TimeUnit.MILLISECONDS);
            }
        } else {
            accessToken = stringRedisTemplate.opsForValue().get(redisKey);
            logger.info("从缓存中拿accessToken:" + accessToken);
        }
        return accessToken;
    }


    /**
     * 获取银行网点配置
     *
     * @auth llc
     * @date 2020-07-31
     */
    @Override
    public List<ConfigBankOutletsDTO> getConfigBankOutlets() {
        String redisKey = PublicConst.REDIS_HEAD + "configBankOutlets";
        String bankListStr = "";
        if (!stringRedisTemplate.hasKey(redisKey)) {
            List<ConfigBankOutletsDTO> bankList = configBankOutletsMapper.getBankOutletsList();
            bankListStr = JSON.toJSONString(bankList);
            stringRedisTemplate.opsForValue().set(redisKey, bankListStr, PublicConst.ONE_WEEK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        } else {
            bankListStr = stringRedisTemplate.opsForValue().get(redisKey);
        }
        List<ConfigBankOutletsDTO> banklist = new ArrayList<>();
        if(StringUtils.isNotEmpty(bankListStr)) {
            banklist = JSON.parseArray(bankListStr, ConfigBankOutletsDTO.class);
        }
        return banklist;
    }
}