package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendLeave;
import com.bcxin.platform.mapper.attend.AttendLeaveMapper;
import com.bcxin.platform.service.attend.AttendLeaveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 考勤请假统计Service业务层处理
 * 
 * @author lin
 * @date 2021-09-07
 */
@Service
@Transactional("transactionManager")
public class AttendLeaveServiceImpl implements AttendLeaveService{

    @Autowired
    private AttendLeaveMapper attendLeaveMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤请假统计
     * 
     * @param id 考勤请假统计ID
     * @return 考勤请假统计
     */
    @Override
    public AttendLeave findById(Long id){
        return attendLeaveMapper.findById(id);
    }

    /**
     * 查询考勤请假统计列表
     * 
     * @param attendLeave 考勤请假统计
     * @return 考勤请假统计
     */
    @Override
    public List<AttendLeave> selectList(AttendLeave attendLeave){
        return attendLeaveMapper.selectList(attendLeave);
    }

    /**
     * 修改考勤请假统计
     * 
     * @param attendLeave 考勤请假统计
     * @return 结果
     */
    @Override
    public int update(AttendLeave attendLeave){
        if(attendLeave.getId() == null){
            attendLeave.setCreateTime(DateUtils.getNowDate());
            attendLeave.setId(idWorker.nextId());
        }else{
            AttendLeave dbAttendLeave = attendLeaveMapper.findById(attendLeave.getId());
            BeanUtils.copyPropertiesIgnore(attendLeave,dbAttendLeave,true);
            BeanUtils.copyPropertiesIgnore(dbAttendLeave,attendLeave,false);
        }
        attendLeave.setUpdateTime(DateUtils.getNowDate());
        return attendLeaveMapper.save(attendLeave);
    }

    /**
     * 删除考勤请假统计对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendLeaveMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 批量保存
     * @param list
     */
    @Override
    public void saveBatch(List<AttendLeave> list){
        //根据数据数量情况，切分不同的大小
        int limit = 200;
        //计算拆分次数
        int count = new Double(Math.ceil(list.size() * 1.0 / limit)).intValue();
        //存放拆分数据
        List<AttendLeave> subList = null;
        //循环拆分次数 生成相应数据文件
        for (int i = 0; i < count; i++) {
            subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());

            List dbLidt = attendLeaveMapper.findByBatchOaLeaveId(subList);
            subList.removeAll(dbLidt);
            if(subList.size() > 0){
                attendLeaveMapper.saveBatch(subList);
            }
        }

    }
}
