package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendCharge;

import java.util.List;

/**
 * 考勤套负责人Service接口
 * 
 * @author lin
 * @date 2021-09-30
 */
public interface AttendChargeService{

    /**
     * 查询考勤套负责人
     * 
     * @param id 考勤套负责人ID
     * @return 考勤套负责人
     */
    AttendCharge findById(Long id);

    /**
     * 查询考勤套负责人列表
     * 
     * @param attendCharge 考勤套负责人
     * @return 考勤套负责人集合
     */
    List<AttendCharge> selectList(AttendCharge attendCharge);


    /**
     * 编辑考勤套负责人
     * 
     * @param attendCharge 考勤套负责人
     * @return 结果
     */
    int update(AttendCharge attendCharge);

    /**
     * 批量删除考勤套负责人
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤套负责人信息
     * 
     * @param id 考勤套负责人ID
     * @return 结果
     */
    int deleteById(Long id);
}
