package com.bcxin.platform.mapper.wallet;

import com.bcxin.platform.domain.wallet.ComWallet;
import com.bcxin.platform.dto.wallet.ComWalletAccountDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业钱包服务
 *
 * @author llc
 * @date 2019-06-21
 */
public interface ComWalletMapper {

    /**
     * <b> 查询是否设置新的商户侧ID有的拿新的，没有就返回comId </b>
     * @author ZXF
     * @create 2022/03/22 0022 16:36
     * @version
     * @注意事项 </b>
     */
    String getMerchantNoByComId(@Param("comId") Long comId);

    /**
     * 查询企业钱包服务
     *
     * @param comId
     * @return
     * @author llc
     * @date 2019-06-21
     */
    ComWallet getComWalletByComId(@Param("comId") Long comId);

    /**
     * 查询企业钱包服务(天翎)
     *
     * @param tlkComId
     * @return
     * @author huzh
     * @date 2021-04-09
     */
    ComWallet getComWalletByTLKComId(@Param("tlkComId") String tlkComId);

    /**
     * 更新企业钱包服务
     *
     * @param comWallet
     * @return
     * @author llc
     * @date 2019-06-24
     */
    int updateComWallet(ComWallet comWallet);

    /**
     * 插入企业钱包服务
     *
     * @param comWallet
     * @return
     * @author lp
     * @date 2019-09-05
     */
    int insertComWallet(ComWallet comWallet);

    /**
     * <b> 业务是否开启锁定 </b>
     * @author ZXF
     * @create 2023/03/31 0031 10:36
     * @version
     * @注意事项 </b>
     */
    Integer isOpenLock(String code);

    List<ComWalletAccountDTO> findWalletAccounts(@Param("list") List<String> list);

}