package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.domain.attend.AttendClock;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * @author linqinglin
 * @date 2021/08/27 0027 14:36
 */
@Data
public class AttendClockDto extends AttendClock {

    /** 人员ID */
    @Excel(name = "人员ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    /** 部门ID */
    @Excel(name = "部门ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long deptId;

    /** 公司ID */
    @Excel(name = "公司ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long attendId;

    /** 上班日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "上班日期", width = 30, dateFormat = "yyyy-MM-dd")
    private String schedulDate;

    /** 考勤套名称 */
    private String attendName;

    /** 班次名称 */
    private String shiftName;

    /** 姓名 */
    private String name;

    /** 部门名称 */
    private String departName;

    /**
     * 上班时间
     */
    private String startTime;
    /**
     * 下班时间
     */
    private String endTime;

    /**
     * v5用户id
     */
    private String tlkPerId;

    /** 班次总时长 */
    private Double shiftHour;

    /**
     * 休息时长
     */
    private Double restHour;

    /** 是否休息 1是0否*/
    private String needRest;

    /** 休息开始时间 */
    private String restStart;

    /** 休息结束时间 */
    private String restEnd;
}
