package com.bcxin.platform.domain.grant;


import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 *
 * 人员银行网点预约
 *
 *
 * @author llc
 * @date 2020-08-21
 */
@TableName("per_bank_outlets_appointment")
@DisMultiTenancy
@Data
public class PerBankOutletsAppointment extends BaseEntity<PerBankOutletsAppointment> {

    /** 人员ID */
    @ApiModelProperty(value = "人员ID")
    private Long perId;

    /**
     * 预约日期
     */
    private Date appointmentDate;

    /**
     * 银行网点工作日人数上限配置ID
     */
    private Integer bankOutletsWorkDayTimePeriodId;

}
