package com.bcxin.platform.service.cache;

/**
 * @Author: 陈堂君
 * @Date: 2018/1/2
 * @Description:
 * @Modified By:
 */
public interface TaskCacheService {

    /**
     * 获取百保盾acessToken
     *
     * @param comId
     * @param platUrl
     * @return accessToken
     * @auth llc
     * @date 2020-06-02
     */
    String getBbdAccessToken(Long comId, String platUrl);


    /**
     * 设置支付平台手机验证码校验码
     *
     * @param key
     * @param value
     * @auth llc
     * @date 2019-06-21
     */
    void setActiveCodeSerial(String key, String value);

    /**
     * 获取支付平台手机验证码校验码
     *
     * @param key
     * @auth llc
     * @date 2019-06-21
     */
    String getActiveCodeSerial(String key);

	/**
	 * 记录手机号发送次数
	 *
	 * @param key
	 * @param count
	 */
	void setSMSPhoneCount(String key, int count);

	/**
	 * 获取手机号短信发送次数
	 *
	 * @param key
	 * @return
	 */
	int getSMSPhoneCount(String key);

	/**
	 * 设置手机验证码缓存
	 *
	 * @param key
	 * @param value
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 16:16
	 */
	void setPhoneAuthCode(String key, String value);

	/**
	 * 获取手机验证码
	 *
	 * @param key
	 * @return
	 * @apiNote 作者 陈堂君
	 * @since 创建于 2018/1/2 16:17
	 */
	String getPhoneAuthCode(String key, String value);


	/**
	 * 获取华为云会议acessToken
	 *
	 * @param userName
	 * @param passWord
	 * @param perId
	 * @return accessToken
	 * @auth llc
	 * @date 2019-07-09
	 */
	String getHuaweiMeetAccessToken(String userName, String passWord, Long perId);


	/**
	 * 获取企业管理员华为云会议acessToken
	 *
	 * @param userName
	 * @param passWord
	 * @param comId
	 * @return accessToken
	 * @auth llc
	 * @date 2019-12-18
	 */
	String getComManageHuaweiMeetAccessToken(String userName, String passWord, Long comId);

	boolean setRoomPerNum(String room, String count);

	String getRoomPerNum(String room);

	/**
	 * <b> 解散房间时删除房间redis记录 </b>
	 *
	 * @author ZXF
	 * @create 2020/08/20 0020 10:27
	 * @version
	 * @注意事项 </b>
	 */
	void delRoom(String room);
}
