package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtil;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendCalendarRest;
import com.bcxin.platform.domain.attend.AttendCalendarRestDetail;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;
import com.bcxin.platform.mapper.attend.AttendCalendarRestDetailMapper;
import com.bcxin.platform.mapper.attend.AttendCalendarRestMapper;
import com.bcxin.platform.service.attend.AttendCalendarRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * 考勤打卡日历套-日历Service业务层处理
 * 
 * @author lin
 * @date 2021-08-10
 */
@Service
@Transactional("transactionManager")
public class AttendCalendarRestServiceImpl implements AttendCalendarRestService {

    @Autowired
    private AttendCalendarRestMapper attendCalendarRestMapper;

    @Autowired
    private AttendCalendarRestDetailMapper attendCalendarRestDetailMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤打卡日历套-日历
     * 
     * @param id 考勤打卡日历套-日历ID
     * @return 考勤打卡日历套-日历
     */
    @Override
    public AttendCalendarRest findById(Long id){
        return attendCalendarRestMapper.findById(id);
    }

    /**
     * 查询考勤打卡日历套-日历列表
     * 
     * @param attendCalendarDetail 考勤打卡日历套-日历
     * @return 考勤打卡日历套-日历
     */
    @Override
    public List<AttendCalendarRestDetailDto> selectList(AttendCalendarRestDetailDto attendCalendarDetail){
        return attendCalendarRestMapper.selectList(attendCalendarDetail);
    }


    @Override
    public int saveBatch(List<AttendCalendarRest> restList){
        for (AttendCalendarRest attendCalendarRest : restList) {
            update(attendCalendarRest);
        }
        return restList.size();
    }

    /**
     * 修改考勤打卡日历套-日历
     * 
     * @param attendCalendarRest 考勤打卡日历套-日历
     * @return 结果
     */
    @Override
    public int update(AttendCalendarRest attendCalendarRest){
        AttendCalendarRestDetailDto attendCalendarRestDetailDto = new AttendCalendarRestDetailDto();

        Map<String, Object> params = new HashMap<>();
        params.put("beginTime",attendCalendarRest.getStartDate());
        params.put("endTime",attendCalendarRest.getEndDate());
        attendCalendarRestDetailDto.setParams(params);
        attendCalendarRestDetailDto.setCalendarId(attendCalendarRest.getCalendarId());
        List<AttendCalendarRestDetailDto> detailDtos = attendCalendarRestDetailMapper.selectList(attendCalendarRestDetailDto);
        if(detailDtos.size() > 0){
            throw new BusinessException(attendCalendarRest.getStartDate()+"~"+attendCalendarRest.getEndDate()+"该日期区间存在交叉数据，请重新设置！");
        }

        if(attendCalendarRest.getId() == null){
            attendCalendarRest.setCreateTime(DateUtils.getNowDate());
            attendCalendarRest.setId(idWorker.nextId());
            attendCalendarRest.setIsDelete(Constants.N);
        }else{
            AttendCalendarRest dbAttendCalendarDetail = attendCalendarRestMapper.findById(attendCalendarRest.getId());
            BeanUtils.copyPropertiesIgnore(attendCalendarRest,dbAttendCalendarDetail,true);
            BeanUtils.copyPropertiesIgnore(dbAttendCalendarDetail,attendCalendarRest,false);
        }

        List<Date> betweenDates = DateUtil.getBetweenDates(attendCalendarRest.getStartDate(), attendCalendarRest.getEndDate());
        List<AttendCalendarRestDetail> details = new ArrayList<>();
        AttendCalendarRestDetail attendCalendarRestDetail = null;
        for (Date betweenDate : betweenDates) {
            attendCalendarRestDetail = new AttendCalendarRestDetail();
            attendCalendarRestDetail.setId(idWorker.nextId());
            attendCalendarRestDetail.setCalendarId(attendCalendarRest.getCalendarId());
            attendCalendarRestDetail.setCalendarType(attendCalendarRest.getCalendarType());
            attendCalendarRestDetail.setRestDate(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,betweenDate));
            attendCalendarRestDetail.setRestId(attendCalendarRest.getId());
            attendCalendarRestDetail.setCreateTime(DateUtils.getNowDate());
            attendCalendarRestDetail.setIsDelete(Constants.N);
            attendCalendarRestDetail.setUpdateTime(DateUtils.getNowDate());
            attendCalendarRestDetail.setUpdateBy(attendCalendarRest.getUpdateBy());
            attendCalendarRestDetail.setCreateBy(attendCalendarRest.getUpdateBy());
            details.add(attendCalendarRestDetail);
        }
        if(details.size() > 0){
            attendCalendarRestDetailMapper.saveBatch(details);
        }
        attendCalendarRest.setUpdateTime(DateUtils.getNowDate());
        return attendCalendarRestMapper.save(attendCalendarRest);
    }

    /**
     * 删除考勤打卡日历套-日历对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendCalendarRestMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤打卡日历套-日历信息
     * 
     * @param id 考勤打卡日历套-日历ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendCalendarRestMapper.deleteById(id);
    }
}
