package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendPerDto;
import com.bcxin.platform.dto.app.AppAttendSchedulDto;
import com.bcxin.platform.dto.attend.AttendSchedulDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤排班Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendSchedulDetailMapper {

    /**
     * 查询考勤排班
     * 
     * @param id 考勤排班ID
     * @return 考勤排班
     */
    AttendSchedulDetail findById(Long id);

    /**
     * 查询考勤排班列表
     * 
     * @param attendSchedul 考勤排班
     * @return 考勤排班集合
     */
    List<AttendSchedulPerPageDto> selectList(AttendSchedulPerPageDto attendSchedul);

    /**
     * 删除考勤排班
     * 
     * @param id 考勤排班ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤排班
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendSchedulDetail
     * @return
     */
    int save(AttendSchedulDetail attendSchedulDetail);

    /****
     * 选择修改
     * @param attendSchedulDetail
     * @return
     */
    int updateSelective(AttendSchedulDetail attendSchedulDetail);

    /**
     * 批量保存
     * @param list
     */
    int saveBatch(@Param("list") List<AttendSchedulDetail> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendSchedulDetail> findByBatchId(@Param("list") List<AttendSchedulDetail> list);

    int removeByPerIds(String[] perIds);

    List<PerBaseInfo> getDepartPerSonList(AttendSchedulPerDto searchDto);

    List<AttendSchedulDetail> getConflictSchedulList(@Param("searchDto") AttendSchedulDto attendSchedulDto, @Param("startTime") String startTime, @Param("endTime") String endTime);

    Long getConflictSchedulCount(@Param("searchDto") AttendSchedulDto attendSchedulDto, @Param("startTime") String startTime, @Param("endTime") String endTime);

    Long getConflictCount(@Param("searchDto") AttendSchedulDto attendSchedulDto, @Param("startTime") String startTime, @Param("endTime") String endTime);

    List<AttendSchedulDetail> selectListForPer(@Param("perId")Long perId, @Param("schedulDate")String schedulDate);

    void remove(AttendSchedulDto attendSchedulDto);

    List<AppAttendSchedulDto> monthDetail(AppAttendSchedulDto searchDto);

    int deleteByPerIds(AppAttendPerDto attendPerDto);
}
