package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;

/**
 * 类别对象 tb_attend_dict
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendDictDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 类别ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /** 名称 */
    @Excel(name = "名称")
    private String dictName;

    /** 类别 */
    @Excel(name = "类别")
    private String dictType;

    /** 是否启用 1是0否 */
    @Excel(name = "是否启用 1是0否")
    private String active;

    /** 是否必须上传附件 0非必须 1必须 */
    @Excel(name = "是否必须上传附件 0非必须 1必须")
    private String annex;

    /**
     * 操作者
     */
    @Excel(name = "操作者")
    private String operator;

    /**
     * 操作时间
     */
    @Excel(name = "操作时间")
    private String operationTime;

}
