package com.bcxin.platform.domain.temporary;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * <b> 临保项目信息 </b>
 * @author ZXF
 * @create 2025/05/29 0029 15:18
 * @version
 * @注意事项 </b>
 */
@TableName("com_project")
@DisMultiTenancy
@Data
public class ComProject extends BaseEntity<ComProject> {
    private static final long serialVersionUID = 1050645601L;

    /**
     * 企业ID
     */
    @ApiModelProperty(value = "项目ID")
    private String tlkProjectId;

    /**
     * 项目名称
     */
    @NotEmpty(message = "项目名称")
    @ApiModelProperty(value = "项目名称")
    private String projectName;
    @ApiModelProperty(value = "项目类型")
    private String projectType;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date endTime;

    /**
     * 具体地址
     */
    @ApiModelProperty(value = "具体地址")
    private String address;

    /**
     * 坐标(经,纬)
     */
    @ApiModelProperty(value = "坐标(经,纬)")
    private String coordinate;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    public ComProject(String tlkProjectId,String projectName,String projectType,String tlkComId,Date startTime,Date endTime,String coordinate,String address){
        this.tlkProjectId = tlkProjectId;
        this.projectName = projectName;
        this.projectType = projectType;
        this.tlkComId = tlkComId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.coordinate = coordinate;
        this.address = address;
    }

    public static ComProject build(String tlkProjectId,String projectName,String projectType,String tlkComId,Date startTime,Date endTime,String coordinate,String address){
        return new ComProject(tlkProjectId,projectName,projectType,tlkComId,startTime,endTime,coordinate,address);
    }
}