package com.bcxin.oaflow.mapper;

import com.bcxin.oaflow.domain.WorkOvertime;
import com.bcxin.oaflow.dto.OaBusinessDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 加班Mapper接口
 * 
 * @author lin
 * @date 2021-09-01
 */
public interface WorkOvertimeMapper{

    /**
     * 查询加班
     * 
     * @param id 加班ID
     * @return 加班
     */
    WorkOvertime findById(String id);

    /**
     * 查询加班列表 针对有排班人员
     * 
     * @param tlkPerIds
     * @param schedulDate
     * @return 加班集合
     */
    List<WorkOvertime> selectList(@Param("list")List<String> tlkPerIds,@Param("schedulDate")String schedulDate);

    /**
     * 查询加班列表 针对休息人员
     *
     * @param tlkPerIds
     * @param schedulDate
     * @return 加班集合
     */
    List<WorkOvertime> selectListForRest(@Param("list")List<String> tlkPerIds,@Param("schedulDate")String schedulDate);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<WorkOvertime> findByBatchId(@Param("list") List<WorkOvertime> list);

    /**
     * 查询出差列表
     *
     * @param tlkPerId
     * @param schedulDate
     * @return 出差集合
     */
    List<OaBusinessDto> findByUserId(@Param("tlkPerId")String tlkPerId, @Param("schedulDate")String schedulDate);
}
