package com.bcxin.platform.service.bbd;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.ObjectUtils;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.log.SysInterfaceLog;
import com.bcxin.platform.dto.wallet.ComWalletTransferDTO;
import com.bcxin.platform.mapper.common.SysPlatMapper;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.log.SysInterfaceLogMapper;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.util.HttpUtils;
import com.bcxin.platform.util.ResultJson;
import com.bcxin.platform.util.ThreadPool;
import com.bcxin.platform.util.codes.ConfigBdpConst;
import com.bcxin.platform.util.constants.BBDServiceConst;
import com.bcxin.platform.util.constants.CommonConst;
import com.bcxin.platform.util.constants.InterfaceTypeConst;
import com.bcxin.platform.util.constants.PlatConst;
import com.bcxin.platform.util.v5.BcxinHttpUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * 百保盾联调
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
@Service
@Transactional("transactionManager")
public class BbdTestServiceImpl implements BbdTestService {

    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;

    @Resource
    private CommonService commonService;

    @Resource
    private TaskCacheService taskCacheService;

    @Resource
    private SysPlatMapper sysPlatMapper;

    @Resource
    private SysInterfaceLogMapper sysInterfaceLogMapper;

    @Resource
    private IdWorker idWorker;

    @Override
    public String bbdGetDffSubsidyList(ComWalletTransferDTO dto) {

        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
        String openSubstation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        String configURL; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(openSubstation) && openSubstation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + comBaseInfo.getRegProvince());
        }
        if (StringUtils.isEmpty(configURL) || configURL.equalsIgnoreCase("null")) {
            return null;
        }
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        String bbdToken = taskCacheService.getBbdAccessToken(comBaseInfo.getComId(), configURL);
        /*** 开始执行百保盾保安资格证申请详细信息获取 ***/
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("sid", bbdToken);
        paramMap.put("pageNumber", dto.getPageNumber().toString());
        paramMap.put("pageSize", dto.getPageSize().toString());
        paramMap.put("order", "desc");
        paramMap.put("subsidyCerType", ObjectUtils.equals(dto.getSubsidyType(), DictConst.SUBSIDYTYPE_BAYZGZKWBT) ? "02" : "01");//01等级证 02 资格证
        paramMap.put("batchName", dto.getBatchName());
        paramMap.put("companynameBatch", dto.getSubsidyObject());
        paramMap.put("applyStartTime", dto.getStartTime());
        paramMap.put("applyEndTime", dto.getEndTime());
        String resultStr = HttpUtil.post(configURL + BBDServiceConst.GET_DFF_SUBSIDY_LIST, paramMap);
        return resultStr;
    }


    @Override
    public String bbdGetBbdSubsidyPageUrl(ComWalletTransferDTO dto) {

        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectComBaseInfoById(dto.getComId());

        String platUrl = sysPlatMapper.getPlatUrl("bbd", comBaseInfo.getRegProvince());

        String bbdSubsidyPageUrl = platUrl + BBDServiceConst.SUBSIDY_DETAIL_PAGE_URL;
        return bbdSubsidyPageUrl;
    }


    @Override
    public Result bbdSyncSubsidyGrantStatus(ComWalletTransferDTO dto) {
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
        String openSubstation = commonService.getSystemConfig(CommonConst.OPEN_SUBSTATION);// 是否开启陕西子站地址默认站点(0：未开启,1：开启)
        String configURL; // 公安子站服务器地址
        if (StringUtils.isNotEmpty(openSubstation) && openSubstation.equals(CommonConst.Y)) {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + "DEFAULT");
        } else {
            configURL = commonService.getSystemConfig(CommonConst.TRACK_ + comBaseInfo.getRegProvince());
        }
        // saas调用百保盾接口之前先判断有没有登陆过，如果没登陆过则需要重新登陆
        String bbdToken = taskCacheService.getBbdAccessToken(comBaseInfo.getComId(), configURL);
        /*** 开始执行百保盾保安资格证申请详细信息获取 ***/
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("sid", bbdToken);
        paramMap.put("id", dto.getBatchNo());
        /*** 记录接口日志 ***/
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1501);
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));

        String url = configURL + BBDServiceConst.SYNC_SUBSIDY_GRANT_STATUS;
        sysInterfaceLog.setUrl(url);
        Result result = new Result();
        try {
            result = syncSubsidyGrantStatus(paramMap, url);
            if (result != null && Result.SUCCESS.equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        } catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("接口调用失败");
        }
        sysInterfaceLog.setEndTime(new Date());
        sysInterfaceLogMapper.insert(sysInterfaceLog);
        return result;
    }

    /**
     * <b> 同步企业人员投保状态到天翎 </b>
     *
     * @param list {"userID":"122","perId":"100","saas_Id":"100","comId":"300","domain_id":"333","insure":"0"}
     * @author ZXF
     * @create 2020/03/18 0018 10:52
     * @version
     * @注意事项 </b>
     */
    @Override
    public void tlSyncPerPolicyStatus(List<Map> list) {
        if (list.size() < 1) {
            return;
        }
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable() {
            @Override
            public void run() {
                String url = commonService.getSystemConfig(CommonConst.BDP_URL);
                Map<String, String> map = commonService.getConfigBdp(ConfigBdpConst.TEEMLINK_BLB_UPDATEINSURESTATUS);
                if(map == null){
                    return;
                }
                /*** 记录接口日志 ***/
                SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
                Long interfaceLogId = idWorker.nextId();
                sysInterfaceLog.setInterfaceLogId(interfaceLogId);
                sysInterfaceLog.setCreateTime(new Date());
                sysInterfaceLog.setInterfaceType(InterfaceTypeConst.INTERFACETYPE_1300);
                sysInterfaceLog.setStartTime(new Date());
                sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
                sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
                sysInterfaceLog.setParameters(JSON.toJSONString(list));
                sysInterfaceLog.setUrl(url);
                try {
                    String ret = BcxinHttpUtil.sendPostRequest(url, map, list);
                    if(StringUtils.isEmpty(ret)){
                        sysInterfaceLog.setInterfaceExecStatus("0");
                        sysInterfaceLog.setResult("");
                    }else{
                        JSONObject json = JSONObject.parseObject(ret);
                        if("200".equals(json.get("status"))){
                            sysInterfaceLog.setInterfaceExecStatus("1");
                        }else{
                            sysInterfaceLog.setInterfaceExecStatus("0");
                            sysInterfaceLog.setResult("");
                        }
                    }
                } catch (Exception e) {
                    sysInterfaceLog.setInterfaceExecStatus("0");
                    sysInterfaceLog.setResult("接口调用失败:" + e.getMessage());
                }
                sysInterfaceLog.setEndTime(new Date());
                sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
    }


    public static Result syncSubsidyGrantStatus(Map paramMap, String url) {
        ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
        if (resultJson != null && resultJson.isSuccessful()) {
            return Result.success(Result.SUCCESS_MSG, resultJson.getData());
        } else {
            return Result.fail(resultJson.getMsg());
        }
    }
}