package com.bcxin.platform.service.attend;

import java.util.List;
import com.bcxin.platform.domain.attend.AttendChangeShift;

/**
 * 换班记录Service接口
 * 
 * @author lin
 * @date 2021-09-20
 */
public interface AttendChangeShiftService{

    /**
     * 查询换班记录
     * 
     * @param id 换班记录ID
     * @return 换班记录
     */
    AttendChangeShift findById(Long id);

    /**
     * 查询换班记录列表
     * 
     * @param attendChangeShift 换班记录
     * @return 换班记录集合
     */
    List<AttendChangeShift> selectList(AttendChangeShift attendChangeShift);


    /**
     * 编辑换班记录
     * 
     * @param attendChangeShift 换班记录
     * @return 结果
     */
    int update(AttendChangeShift attendChangeShift);

    /**
     * 批量删除换班记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除换班记录信息
     * 
     * @param id 换班记录ID
     * @return 结果
     */
    int deleteById(Long id);
}
