package com.bcxin.platform.mapper.order;


import com.bcxin.platform.domain.order.ComOrderConfirmPay;
import com.bcxin.platform.util.CrudDao;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <b> 华为订单确认支付表 </b>
 * @author ZXF
 * @create 2020/06/01 0001 14:44
 * @version
 * @注意事项 </b>
 */
@Component
public interface ComOrderConfirmPayMapper extends CrudDao<ComOrderConfirmPay> {

    int batchInsert(@Param("comOrderId") Long comOrderId, @Param("list") List<String> list);

    int batchUpdate(@Param("list") List<ComOrderConfirmPay> list);

    int update(ComOrderConfirmPay pay);

    /**
     * <b> 查询未产生流水号的订单号 </b>
     * @author ZXF
     * @create 2020/06/01 0001 15:04
     * @version
     * @注意事项 </b>
     */
    List<String> findUnConfirmPayOrderNosByOrderId(Long comOrderId);

    List<ComOrderConfirmPay> selectByComOrderId(Long comOrderId);
}