package com.bcxin.platform.domain.order;

import com.bcxin.platform.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <b> 华为订单确认支付表 </b>
 * @author ZXF
 * @create 2020/06/01 0001 14:42
 * @version
 * @注意事项 </b>
 */
@Data
@TableName("com_order_confirm_pay")
public class ComOrderConfirmPay {

	/** 企业订单ID */
	@ApiModelProperty(value = "企业订单ID")
	private Long comOrderId;

	/** 订单号 */
	@ApiModelProperty(value = "订单号")
	private String orderNo;

	/** 支付流水号 */
	@ApiModelProperty(value = "支付流水号")
	private String tradeNo;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComOrderId() {
		return comOrderId;
	}

}