package com.bcxin.platform.util.file;

import cn.hutool.http.HttpUtil;
import com.bcxin.platform.util.constants.Constants;
import com.bcxin.platform.util.file.obs.OBSUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;

/**
 * <b> 工具类，用来迁移obs文件，实现远程地址存储到指定桶原路径下 </b>
 * @author ZXF
 * @create 2024/12/09 0009 14:43
 * @version
 * @注意事项 </b>
 */
@Slf4j
public class CopyFileUtil {

    private static OBSUtil obsUtil = new OBSUtil(Constants.ENVI_PROD);
    private static String huaweiOBSFileUpload(String url) {
        String[] arr;
        if(url.contains(".oss")){
            return "0";
        }else if(url.contains("443/")){
            arr = url.split("443/");
        }else{
            arr = url.split("baibaodun.cn/");
        }
        Path path = Paths.get(arr[1]);
        /* 组装成随机文件名称 12345.jpg */
//        String fileName = path.getFileName().toString();
        /* 生成目录 */
        String directoryName = path.getParent().toString();
        String ossKey = arr[1];

        /* 利用jdk7的特性，执行完后自动关闭流对象 */
        try (InputStream inputStream = HttpUtil.createGet(url).execute().bodyStream();) {
            return obsUtil.put(directoryName, ossKey, inputStream);
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
        }
        return "1";
    }

    public static void main(String[] args) {
        //https://bcxin-pasp-prod.obs.cn-north-4.myhuaweicloud.com/upload%2F2024-11-29%2F1732881029453669738.pdf
        String urls = "https://bcxinsaasprod.baibaodun.cn:443/upload/2024-11-20/1732082660382226858.wgt," +
                "https://bcxinsaasprod.baibaodun.cn:443/upload/2024-09-23/1727058203760495623.wgt," +
                "https://bcxinsaasprod.baibaodun.cn:443/upload/2024-10-09/1728467236012941511.wgt";
        String[] arr = urls.replace(",,",",").split(",");
        for (String url : arr) {
            huaweiOBSFileUpload(url);
        }
    }
}
