package com.bcxin.platform.service.system.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.system.SysRegion;
import com.bcxin.platform.mapper.system.SysRegionMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.system.ISysRegionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 地区Service业务层处理
 * 
 * @author task
 * @date 2021-01-22
 */
@Service
public class SysRegionServiceImpl implements ISysRegionService
{
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private CommonService commonService;

    /**
     * 查询地区
     * 
     * @param regionId 地区ID
     * @return 地区
     */
    @Override
    public SysRegion selectSysRegionById(Long regionId)
    {
        return sysRegionMapper.selectSysRegionById(regionId);
    }

    /**
     * 查询地区列表
     * 
     * @param sysRegion 地区
     * @return 地区
     */
    @Override
    public List<SysRegion> selectSysRegionList(SysRegion sysRegion)
    {
        return sysRegionMapper.selectSysRegionList(sysRegion);
    }

    /**
     * <b> 递归省市区 </b>
     * @author ZXF
     * @create 2021/06/25 0025 11:16
     * @version
     * @注意事项 </b>
     */
    @Override
    public Object getRegions() {
        Result ret = commonService.getRegions();
        if(Result.SUCCESS.equals(ret.getRetType())){
            return ret.getData();
        }
        return null;
    }

}
