package com.bcxin.platform.service.oauth;


import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.oauth.AccessToken;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface OAuthService {

    /**
     * 获取token处理
     *
     * @param response
     * @throws Exception
     */
    Result saveDispatch(HttpServletRequest request, HttpServletResponse response, String clientType)
            throws Exception;

    AccessToken getAccessToken(String clientType, PerBaseInfo perBaseInfo) throws OAuthSystemException;

    /**
     * 通过access_token获取AccessToken对象
     *
     * @param access_token
     * @return
     * @throws Exception
     */
    AccessToken getAccessToken(String access_token);


    AccessToken getAccessToken(String access_token,boolean userV5Token);
}
