package com.bcxin.platform.service.grant;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComBhGrantDetail;
import com.bcxin.platform.domain.grant.ComBhGrantInfo;
import com.bcxin.platform.dto.grant.ComBhGrantInfoDTO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 企业渤海薪资发放
 * @author  llc
 * @date 2020-08-13
 */
public interface ComBhGrantService {

    /**
     * 获取薪资代发记录
     * @param dto
     * @author lp
     * @date 2019-07-01
     * @return
     */
    Result pageComBhGrantInfoList(ComBhGrantInfoDTO dto) throws V5BusinessException;


    /**
     * 创建企业渤海薪资代发单
     * @param comBhGrantInfo
     * @author lp
     * @date 2019-07-01
     * @return
     */
    Result saveComBhGrantInfo(ComBhGrantInfo comBhGrantInfo) throws V5BusinessException;


    /**
     * 根据id获取企业渤海薪资代发
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-08-13
     */
    Result getComBhGrantInfoById(ComBhGrantInfoDTO dto) throws V5BusinessException;



    /**
     * 删除企业渤海薪资代发单
     * @param dto
     * @author llc
     * @date 2020-08-13
     */
    Result deleteComBhGrantInfo(ComBhGrantInfoDTO dto)  throws V5BusinessException;


    /**
     * 获取企业渤海薪资发放明细
     * @param dto
     * @author llc
     * @date 2020-08-14
     */
    Result pageComBhGrantDetailList(ComBhGrantInfoDTO dto)  throws V5BusinessException;


    /***
     * 导出渤海薪资代发模板
     * @param dto
     * @author llc
     * @date 2020-08-13
     * @return
     * @throws V5BusinessException
     */
    Result exportOfflineGrantTemp(ComBhGrantInfoDTO dto, HttpServletResponse response) throws V5BusinessException;


    /***
     * 导入渤海薪资代发模板
     * @param dto
     * @author llc
     * @date 2020-08-13
     * @return
     * @throws V5BusinessException
     */
    Result importOfflineGrantTemp(MultipartFile xfile, ComBhGrantInfoDTO dto) throws V5BusinessException;


    /***
     * 导出渤海薪资银行卡代发模板
     * @param dto
     * @author llc
     * @date 2020-12-04
     * @return
     * @throws V5BusinessException
     */
    Result exportOfflineBankGrantTemp(ComBhGrantInfoDTO dto, HttpServletResponse response) throws V5BusinessException;


    /***
     * 导入渤海薪资银行卡代发模板
     * @param dto
     * @author llc
     * @date 2020-12-04
     * @return
     * @throws V5BusinessException
     */
    Result importOfflineBankGrantTemp(MultipartFile xfile, ComBhGrantInfoDTO dto) throws V5BusinessException;



    /**
     * 删除企业渤海薪资代明细
     * @param comBhGrantDetail
     * @author llc
     * @date 2020-08-17
     */
    Result deleteComBhGrantDetailById(ComBhGrantDetail comBhGrantDetail)  throws V5BusinessException;


    /**
     * 提交发放申请
     * @param dto
     * @author llc
     * @date 2020-08-17
     */
    Result commitGrantApply(ComBhGrantInfoDTO dto)  throws V5BusinessException;


    /**
     * 提交发放申请（测试用）
     * @param dto
     * @author llc
     * @date 2020-08-17
     */
    Result commitGrantApplyCs(ComBhGrantInfoDTO dto)  throws V5BusinessException;


    /**
     * 查询企业渤海发放操作记录列表
     * @param dto
     * @author llc
     * @date 2020-08-17
     */
    Result getBhGrantOperRecordList(ComBhGrantInfoDTO dto)  throws V5BusinessException;


    /**
     * 获取渤海银行回单文件URL
     * @param dto
     * @author llc
     * @date 2020-09-16
     */
    Result getBhBankReceiptFileUrl(ComBhGrantInfoDTO dto)  throws V5BusinessException;


    /**
     * 同步渤海发放结果
     * @param dto
     * @author llc
     * @date 2020-09-17
     */
    Result syncBhGrantResult(ComBhGrantInfoDTO dto)  throws V5BusinessException;

}