package com.bcxin.platform.service.company;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.dto.company.ComBaseInfoDto;
import com.bcxin.platform.dto.company.ComDTO;

import java.util.List;
import java.util.Map;

/**
 * 企业基础信息Service接口
 * 
 * @author lin
 * @date 2021-04-09
 */
public interface ComBaseInfoService{

    /**
     * 查询企业基础信息
     * 
     * @param comId 企业基础信息ID
     * @return 企业基础信息
     */
    ComBaseInfo selectComBaseInfoById(Long comId);

    /**
     * 查询企业基础信息列表
     * 
     * @param comBaseInfo 企业基础信息
     * @return 企业基础信息集合
     */
    List<ComBaseInfo> selectComBaseInfoList(ComBaseInfo comBaseInfo);

    /**
     * 新增企业基础信息
     * 
     * @param comBaseInfo 企业基础信息
     * @return 结果
     */
    int insertComBaseInfo(ComBaseInfo comBaseInfo);

    /**
     * 修改企业基础信息
     * 
     * @param comBaseInfo 企业基础信息
     * @return 结果
     */
    int updateComBaseInfo(ComBaseInfo comBaseInfo);

    /**
     * 批量删除企业基础信息
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteComBaseInfoByIds(String ids);

    /**
     * 删除企业基础信息信息
     * 
     * @param comId 企业基础信息ID
     * @return 结果
     */
    int deleteComBaseInfoById(Long comId);

    /**
     * 获取企业信息详情
     *
     * @param comBaseInfoDto
     * @return
     */
    Result getByPrimaryKey(ComBaseInfoDto comBaseInfoDto);

    /**
     * 查询企业基础信息
     *
     * @param tklComId v5企业基础信息ID
     * @return 企业基础信息
     */
    ComBaseInfo selectComBaseInfoByTlkId(String tklComId);

    ComDTO selectByID(ComDTO dto);

    List<Map> queryCompanyCombobox();
}
