package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendSchedulConflict;
import com.bcxin.platform.dto.app.AppAttendSchedulConflictDto;
import com.bcxin.platform.mapper.attend.AttendSchedulConflictMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import com.bcxin.platform.service.attend.AttendSchedulConflictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 考勤排班冲突Service业务层处理
 * 
 * @author lin
 * @date 2022-02-14
 */
@Service
@Transactional
public class AttendSchedulConflictServiceImpl implements AttendSchedulConflictService{

    @Autowired
    private AttendSchedulConflictMapper attendSchedulConflictMapper;

    @Autowired
    private AttendSchedulDetailMapper attendSchedulDetailMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤排班冲突
     * 
     * @param id 考勤排班冲突ID
     * @return 考勤排班冲突
     */
    @Override
    public AttendSchedulConflict findById(Long id){
        return attendSchedulConflictMapper.findById(id);
    }

    /**
     * 查询考勤排班冲突列表
     * 
     * @param attendSchedulConflict 考勤排班冲突
     * @return 考勤排班冲突
     */
    @Override
    public List<AttendSchedulConflict> selectList(AttendSchedulConflict attendSchedulConflict){
        return attendSchedulConflictMapper.selectList(attendSchedulConflict);
    }

    @Override
    public List<AppAttendSchedulConflictDto> findByAttendId(Long attendId) {
        return attendSchedulConflictMapper.findByAttenId(attendId);
    }

    /**
     * 修改考勤排班冲突
     * 
     * @param attendSchedulConflict 考勤排班冲突
     * @return 结果
     */
    @Override
    public int update(AttendSchedulConflict attendSchedulConflict){
        if(attendSchedulConflict.getId() == null){
            attendSchedulConflict.setCreateTime(DateUtils.getNowDate());
            attendSchedulConflict.setId(idWorker.nextId());
        }else{
            AttendSchedulConflict dbAttendSchedulConflict = attendSchedulConflictMapper.findById(attendSchedulConflict.getId());
            BeanUtils.copyPropertiesIgnore(attendSchedulConflict,dbAttendSchedulConflict,true);
            BeanUtils.copyPropertiesIgnore(dbAttendSchedulConflict,attendSchedulConflict,false);
        }
        attendSchedulConflict.setUpdateTime(DateUtils.getNowDate());
        return attendSchedulConflictMapper.save(attendSchedulConflict);
    }

    /**
     * 删除考勤排班冲突对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendSchedulConflictMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤排班冲突信息
     * 
     * @param id 考勤排班冲突ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendSchedulConflictMapper.deleteById(id);
    }

    @Override
    public int cover(AttendSchedulConflict attendSchedulConflict) {
        synchronized (attendSchedulConflict.getId()) {
            AttendSchedulConflict schedulConflict = attendSchedulConflictMapper.findById(attendSchedulConflict.getId());
            if(Constants.Y.equals(schedulConflict.getIsDelete())){
                throw new BusinessException("该冲突已重排，请勿重复操作！");
            }
            if(Constants.Y.equals(schedulConflict.getConflictState())){
                throw new BusinessException("该冲突已覆盖，请勿重复操作！");
            }
            attendSchedulDetailMapper.save(schedulConflict);
            attendSchedulConflictMapper.coverSchedul(attendSchedulConflict);
            return attendSchedulConflictMapper.coverConflict(attendSchedulConflict);
        }
    }
}
