package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendCalendarRestDetail;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;
import com.bcxin.platform.mapper.attend.AttendCalendarRestDetailMapper;
import com.bcxin.platform.service.attend.AttendCalendarRestDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 考勤打卡日历套-日历-假日Service业务层处理
 * 
 * @author lin
 * @date 2021-08-10
 */
@Service
@Transactional("transactionManager")
public class AttendCalendarRestDetailServiceImpl implements AttendCalendarRestDetailService {

    @Autowired
    private AttendCalendarRestDetailMapper attendCalendarRestDetailMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤打卡日历套-日历-假日
     * 
     * @param id 考勤打卡日历套-日历-假日ID
     * @return 考勤打卡日历套-日历-假日
     */
    @Override
    public AttendCalendarRestDetail findById(Long id){
        return attendCalendarRestDetailMapper.findById(id);
    }

    /**
     * 查询考勤打卡日历套-日历-假日列表
     * 
     * @param attendCalendarRestDetailDto 考勤打卡日历套-日历-假日
     * @return 考勤打卡日历套-日历-假日
     */
    @Override
    public List<AttendCalendarRestDetailDto> selectList(AttendCalendarRestDetailDto attendCalendarRestDetailDto){
        return attendCalendarRestDetailMapper.selectList(attendCalendarRestDetailDto);
    }

    /**
     * 修改考勤打卡日历套-日历-假日
     * 
     * @param attendCalendarRestDetail 考勤打卡日历套-日历-假日
     * @return 结果
     */
    @Override
    public int update(AttendCalendarRestDetail attendCalendarRestDetail){
        if(attendCalendarRestDetail.getId() == null){
            attendCalendarRestDetail.setCreateTime(DateUtils.getNowDate());
            attendCalendarRestDetail.setId(idWorker.nextId());
        }else{
            AttendCalendarRestDetail dbAttendCalendarRestDetail = attendCalendarRestDetailMapper.findById(attendCalendarRestDetail.getId());
            BeanUtils.copyPropertiesIgnore(attendCalendarRestDetail,dbAttendCalendarRestDetail,true);
            BeanUtils.copyPropertiesIgnore(dbAttendCalendarRestDetail,attendCalendarRestDetail,false);
        }
        attendCalendarRestDetail.setUpdateTime(DateUtils.getNowDate());
        return attendCalendarRestDetailMapper.save(attendCalendarRestDetail);
    }

    /**
     * 删除考勤打卡日历套-日历-假日对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){

        //TODO 判断日历是否已被使用，如果被使用则不能删除


        return attendCalendarRestDetailMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤打卡日历套-日历-假日信息
     * 
     * @param id 考勤打卡日历套-日历-假日ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendCalendarRestDetailMapper.deleteById(id);
    }
}
