package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.dto.app.AppAttendDto;
import com.bcxin.platform.dto.app.AppAttendEditDto;
import com.bcxin.platform.dto.app.AppAttendManageDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendDto;

import java.util.List;

/**
 * 考勤套Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendService{

    /**
     * 查询考勤套
     * 
     * @param id 考勤套ID
     * @return 考勤套
     */
    Attend findById(Long id);

    /**
     * 查询考勤套列表
     * 
     * @param attend 考勤套
     * @return 考勤套集合
     */
    List<Attend> selectList(AttendDto attend);


    /**
     * 编辑考勤套
     * 
     * @param attend 考勤套
     * @return 结果
     */
    int update(Attend attend);

    /**
     * 批量删除考勤套
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    List<Attend> selectListForPer(AttendDto attend);

    /**
     * 查询用户考勤套
     * @param searchDto
     * @return
     */
    AppAttendDto findByPerId(AppAttendSearchDto searchDto);

    Integer getCountLimit(AppAttendSearchDto searchDto);

    List<Attend> selectListForChargePer(AttendDto attend);

    List<AppAttendManageDto> selectManageListForChargePer(AttendDto attend);

    int updateForApp(AppAttendEditDto attend);
}
