package com.bcxin.platform.service.attend;

import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendSchedulDto;
import com.bcxin.platform.dto.attend.AttendSchedulDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerPageDto;

import java.util.List;

/**
 * 考勤排班Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendSchedulService {

    /**
     * 查询考勤排班
     * 
     * @param id 考勤排班ID
     * @return 考勤排班
     */
    AttendSchedulDetail findById(Long id);

    /**
     * 查询考勤排班列表
     * 
     * @param attendSchedul 考勤排班
     * @return 考勤排班集合
     */
    List<AttendSchedulPerPageDto> selectList(AttendSchedulPerPageDto attendSchedul);


    /**
     * 编辑考勤排班
     * 
     * @param attendSchedul 考勤排班
     * @return 结果
     */
    int update(AttendSchedulDetail attendSchedul);

    /**
     * 批量删除考勤排班
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤排班信息
     * 
     * @param id 考勤排班ID
     * @return 结果
     */
    int deleteById(Long id);

    int save(AttendSchedulDto attendSchedul);


    /**
     * 获取选人公共部门树的人员列表
     * @param searchDto
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    List<PerBaseInfo> getDepartPersonList(AttendSchedulPerDto searchDto);

    List<AppAttendSchedulDto> monthDetail(AppAttendSchedulDto searchDto);

    AjaxResult saveForWeeks(AttendSchedulDto attendSchedul);
}
