package com.bcxin.platform.mapper.wallet;

import com.bcxin.platform.domain.wallet.ComWalletTrade;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业钱包交易信息
 *
 * @author llc
 * @date 2019-06-28
 */
public interface ComWalletTradeMapper {

    /**
     * 插入企业钱包账户交易记录
     *
     * @param comWalletTrade
     * @return
     * @author llc
     * @date 2019-06-28
     */
    int insertComWalletTrade(ComWalletTrade comWalletTrade);

    /**
     * <b> 根据流水号查是否存在已完成支付的记录 </b>
     * @author ZXF
     * @create 2023/04/04 0004 16:08
     * @version
     * @注意事项 </b>
     */
    int getComWalletTradeByReq(@Param("businessPartnerSeq") String businessPartnerSeq,@Param("tradeType") String tradeType);


    /**
     * 更新企业钱包账户交易记录
     *
     * @param comWalletTrade
     * @return
     * @author llc
     * @date 2019-06-28
     */
    int updateComWalletTrade(ComWalletTrade comWalletTrade);


    /**
     * 查询企业钱包交易信息
     *
     * @param comWalletTradeId
     * @return
     * @author llc
     * @date 2019-06-28
     */
    ComWalletTrade getComWalletTradeById(@Param("comWalletTradeId") Long comWalletTradeId);

    /**
     * <b> 根据业务编码或业务流水查询交易信息 </b>
     * @author ZXF
     * @create 2023/03/23 0023 10:17
     * @version
     * @注意事项 </b>
     */
    List<ComWalletTrade> getComWalletTradeBySeqAndCode(ComWalletTrade comWalletTrade);

    /**
     * <b> 查询企业钱包交易信息 </b>
     * @param comWalletTradeId
     * @param comId (必填)
     * @param comment
     * @param tradeStatus
     * @author ZXF
     * @create 2022/06/27 0027 14:19
     * @version
     * @注意事项 </b>
     */
    List<ComWalletTrade> findComWalletTrade(ComWalletTrade comWalletTrade);


}