package com.bcxin.platform.mapper.insurance;

import com.bcxin.platform.domain.insurance.ComIns;
import com.bcxin.platform.dto.insurance.BLBComInfoDTO;
import com.bcxin.platform.dto.insurance.ComInsDTO;
import com.bcxin.platform.dto.insurance.InsPerDTO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public interface ComInsMapper {
    int delete(Long comInsId);
    int insert(ComIns record);
    int update(ComIns record);

    /**
     * <b> 人员批量添加过滤记录 </b>
     * @author ZXF
     * @create 2019/03/26 0026 17:55
     * @version
     * @注意事项 </b>
     */
    int addBatchFilterPerson(@Param("comId") Long comId, @Param("ids") String[] ids);

    /**
     * <b> 人员批量删除过滤记录 </b>
     * @author ZXF
     * @create 2019/03/26 0026 17:55
     * @version
     * @注意事项 </b>
     */
    int delBatchFilterPerson(@Param("comId") Long comId, @Param("ids") String[] ids);

    /**
     * 根据保险订单的唯一标识 查询保险表信息详情
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:49
     * @param blbOrderId
     * @return
     */
    List<Map> selectByBlbOrderId(@Param("blbOrderId") String blbOrderId);

    /**
     * <b> 根据保单号 查询保险表信息详情 </b>
     * @author ZXF
     * @create 2022/08/24 0024 15:52
     * @version
     * @注意事项 </b>
     */
    List<Map> selectByBlbPolicyNo(@Param("policyNo") String policyNo);

    /**
     * <b> 保存电子保单地址 </b>
     * @author ZXF
     * @create 2019/05/10 0010 15:25
     * @version
     * @注意事项 </b>
     */
    int updatePolicyUrlByOrderId(@Param("blbOrderId") String blbOrderId,@Param("policyUrl") String policyUrl);

    /**
     * <b> 根据百联保订单id逻辑删除保单 </b>
     * @author ZXF
     * @create 2020/01/10 0010 16:45
     * @version
     * @注意事项 </b>
     */
    int deleteComInsByBlbOrderId(@Param("blbOrderId") String blbOrderId);

    /**
     * 保险列表的分页查询
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:49
     * @param dto
     * @return
     */
    List<Map<String,Object>> getComInsPage(ComInsDTO dto);

    /**
     * <b> 个人已投保保险列表的分页查询 </b>
     * @author ZXF
     * @create 2021/12/07 0007 14:52
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> getPerInsPage(Long perId);

    List<Map<String,Object>> getPerInsPageNew(@Param("comId") Long comId,@Param("idCardNo") String idCardNo);

    /**
     * <b> 根据身份证查询保险列表 </b>
     * @author ZXF
     * @create 2020/06/19 0019 15:03
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> getComInsByIdcard(ComInsDTO dto);

    /**
     * <b> 根据身份证查询线上平安雇主保险的保单列表 </b>
     * @author ZXF
     * @create 2020/06/19 0019 15:03
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> getComInsByIdcardAndXS(ComInsDTO dto);

    /**
     * <b> 查询线下或线上保险列表 </b>
     * @author ZXF
     * @create 2019/03/27 0027 10:53
     * @version
     * @注意事项 </b>
     */
    List<Map> findOfflineOrOnlinePolicy(InsPerDTO dto);

    /**
     * 根据保险方案ID 查询保险表信息详情
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/10 10:49
     * @param comInsId
     * @return
     */
    Map<String,Object> selectById(@Param("comInsId") Long comInsId);

    /**
     *  获取企业信息
     *   0	身份证  1 组织机构代码证 2	三证合一信用代码 3	护照  4	台胞证 5	回乡证 6	税务登记证 7	营业执照  8	其他
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/4 13:29
     * @param comId 企业ID
     */
    List<BLBComInfoDTO> getCompanyByComID(@Param("comId") Long comId);

    /**
     * 获取企业人员信息
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/1/4 13:29
     * @param comId 企业ID
     * @param limit 条数
     */
    List<BLBComInfoDTO> getPersonByComID(@Param("comId") Long comId, @Param("limit") int limit);

    List<BLBComInfoDTO> getPersonByperIds(@Param("ids") String[] ids);

    /**
     * 获取基础人员信息id
     * @apiNote  作者 zxf
     * @since 创建于 2018/9/19 19:40
     * @param comId 企业ID
     * @param idCardNo 人员证件号码
     */
    Long getPerIdByComIDAndIdCardNo(@Param("comId") Long comId, @Param("idCardNo") String idCardNo);

    int updateComInsRemark(@Param("comInsId") Long comInsId, @Param("remark") String remark);

    /**
     * <b> 判断保单号是否存在 </b>
     * @author ZXF
     * @create 2020/04/23 0023 16:53
     * @version
     * @注意事项 </b>
     */
    Integer isPolicyNo(ComInsDTO dto);

    /**
     * 根据任务找需要投保的保险产品
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/2 11:00
     */
    List<Map<String,Object>> selectInsCodeByTask(@Param("regionId") Long regionId,@Param("comId") Long comId);

    /**
     * 根据在线保险表的主键，去统计再保人数
     *  @apiNote  作者 陈堂君
     * @since 创建于 2018/4/2 11:00
     */
    Map countByComInsId(@Param("comInsId") Long comInsId);

    /**
     * 根据企业ID去查询该公司的在线保险订单
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/2 11:00
     */
    List<Map> selectOnlineByComId(@Param("comId") Long comId,@Param("buyMode") Integer buyMode);


    /**
     * 根据企业ID获得对应的保险规则
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/2 11:00
     */
    Map getInsRuleByComId(@Param("comId") Long comId);

    /**
     * 返回isPerCntRight为1标识投保人数满足，如果为0标识不满足，并且diffCnt标识差多少人没投保
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/2 13:19
     */
    Map getInsPerCntIsRight(@Param("comId")Long comId);


    /**
     * 判断某个企业的保障项目是否满足，返回isGood如果为0，标识这个保障项目不满足
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/17 10:15
     */
    List<Map> getInsGuaProjectIsRight(@Param("comId") Long comId);

    /**
     * 遍历所有激活，有效的保险规则
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/17 10:15
     */
    List<Map> getAllComInsRules();

    /**
     * 查询某个企业下的管理员信息
     * @param comId
     * @return
     */
    List<Map> getComAdminInfo(@Param("comId") Long comId);

    /**
     * 查询企业已经发送过这类的消息
     * @param comId
     * @return
     */
    Map getComHisMsgCnt(@Param("comId")Long comId, @Param("messageType") String messageType);

    /**
     * 方案书分页查询
     * @apiNote  作者 陈堂君
     * @since 创建于 2018/4/18 19:00
     */
    List<Map> getInsBootPage(ComInsDTO dto);

    /**
     * <b> 查询将到期保单，第一个日期参数必传 </b>
     * @author ZXF
     * @create 2019/04/01 0001 13:51
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> findMaturingPolicy(@Param("aDay")String aDay, @Param("bDay")String bDay, @Param("cDay")String cDay);
    List<String> allLosePolicyNos();

    /**
     * <b> 查询在保人员设置到保单记录统计字段 </b>
     * @author ZXF
     * @create 2019/05/15 0015 10:38
     * @version
     * @注意事项 </b>
     */
    int changeInsPerCount(@Param("comInsId") Long comInsId);

    /**
     * <b> 查询线下剩余可关联人数 </b>
     * @author ZXF
     * @create 2020/01/16 0016 20:06
     * @version
     * @注意事项 </b>
     */
    int offlineResidualFelatableQuantity(@Param("comInsId") Long comInsId);

    /**
     * <b> 查询线下保单并且标注百联保的保单号列 </b>
     * @author ZXF
     * @create 2020/04/20 0020 10:19
     * @version
     * @注意事项 </b>
     */
    String findPolicysByOfflineBLBSign();

    /**
     * <b> 根据保单号修改在保人数 </b>
     * @author ZXF
     * @create 2020/04/20 0020 10:51
     * @version
     * @注意事项 </b>
     */
    int updateZBNumByPolicyNo(@Param("list") List<Map> list);
}
