package com.bcxin.platform.mapper.grant;


import com.bcxin.platform.domain.grant.ComBhGrantInfo;
import com.bcxin.platform.dto.grant.ComBhGrantInfoDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业渤海薪资发放记录
 *
 * @author llc
 * @date 2020-08-17
 */
public interface ComBhGrantInfoMapper {

    /**
     * 查询企业渤海薪资代发单
     * @param comBhGrantId
     * @author llc
     * @date 2020-08-13
     * @return
     */
    ComBhGrantInfo getComBhGrantInfoById(@Param("comBhGrantId") Long comBhGrantId);

    /**
     * 删除企业渤海薪资代发单
     * @param comBhGrantId
     * @author llc
     * @date 2020-08-13
     * @return
     */
    int deleteById(@Param("comBhGrantId") Long comBhGrantId);


    /**
     * 插入企业渤海薪资代发
     * @param comBhGrantInfo
     * @author llc
     * @date 2020-08-13
     * @return
     */
    int insertComBhGrantInfo(ComBhGrantInfo comBhGrantInfo);


    /**
     * 更新渤海薪资代发单
     * @param comBhGrantInfo
     * @author llc
     * @date 2020-08-14
     * @return
     */
    int updateComBhGrantInfo(ComBhGrantInfo comBhGrantInfo);


    /**
     * 查询企业渤海薪资代发列表
     * @param dto
     * @author llc
     * @date 2020-08-14
     * @return
     */
    List<Map<String, String>> pageComBhGrantInfoList(ComBhGrantInfoDTO dto);


    /**
     * 插入线下渤海代发导入记录
     * @param list
     * @param importBatchId
     * @author llc
     * @date 2020-08-17
     */
    Integer insertTempOfflineBhGrant(@Param("list") List<Map<String, String>> list,
                                     @Param("importBatchId") Long importBatchId);


    /**
     * 线下渤海代发导入-校验导入的人员是否存在身份证重复
     * @param importBatchId
     * @author llc
     * @date 2020-08-17
     */
    Integer checkIdCardNoRepeat(@Param("importBatchId") Long importBatchId);


    /**
     * 线下渤海代发导入-校验导入的人员是否身份证存在
     * @param importBatchId
     * @author llc
     * @date 2020-08-17
     */
    Integer checkExistsIdCard(@Param("importBatchId") Long importBatchId);


    /**
     * 线下渤海代发导入-校验导入的人员是否存在银行卡重复
     * @param importBatchId
     * @author llc
     * @date 2020-12-07
     */
    Integer checkBankCardNoRepeat(@Param("importBatchId") Long importBatchId);


    /**
     * 线下渤海代发导入-更新人员ID
     * @param importBatchId
     * @author llc
     * @date 2020-08-17
     */
    Integer updateCheckPassPerId(@Param("importBatchId") Long importBatchId);


    /**
     * 线下渤海代发导入-校验导入的人员是否属于企业
     * @param importBatchId
     * @param comId
     * @author llc
     * @date 2020-08-17
     */
    Integer checkIdCardNoInCom(@Param("importBatchId") Long importBatchId, @Param("comId") Long comId);

    /**
     * 线下渤海代发导入-校验导入的人员是否存在保安员联名卡
     * @param importBatchId
     * @author llc
     * @date 2020-08-17
     */
    Integer checkPerExistsJointlyCard(@Param("importBatchId") Long importBatchId);


    /**
     * 线下渤海代发导入-校验是否存在记录
     * @param importBatchId
     * @param comBhGrantId
     * @author llc
     * @date 2020-08-18
     */
    Integer checkExistsRecord(@Param("importBatchId") Long importBatchId, @Param("comBhGrantId") Long comBhGrantId);


    /**
     * 线下渤海代发导入-更新发放信息
     * @param importBatchId
     * @param updateBy
     * @param comBhGrantId
     * @param grantYears
     * @param grantDataSource
     * @author llc
     * @date 2020-08-17
     */
    Integer updateBhGrantInfo(@Param("importBatchId") Long importBatchId,
                              @Param("updateBy") Long updateBy,
                              @Param("comBhGrantId") Long comBhGrantId,
                              @Param("grantYears") String grantYears,
                              @Param("grantDataSource") String grantDataSource);

    /**
     * 获取线下渤海代发导入记录
     *
     * @param importBatchId
     * @author llc
     * @date 2020-08-17
     */
    List<Map<String, String>> getTempOfflineBhGrantList(@Param("importBatchId") Long importBatchId);

    /**
     * 删除线下渤海代发导入临时表
     *
     * @param importBatchId
     * @author llc
     * @date 2020-08-17
     */
    Integer deleteTempOfflineBhGrantImport(@Param("importBatchId") Long importBatchId);




}