package com.bcxin.platform.mapper.company;

import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.dto.company.ComDepartTreeDto;
import com.bcxin.platform.dto.company.OrgTreeDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 部门Mapper接口
 *
 * @author lin
 * @date 2021-04-09
 */
public interface ComDepartMapper{

    /**
     * 查询部门
     *
     * @param departId 部门ID
     * @return 部门
     */
    ComDepart selectComDepartById(Long departId);

    /**
     * 查询部门
     *
     * @param tlkDepartIds 部门IDs
     * @return 部门
     */
    List<ComDepart> selectComDepartByTlkIds(String[] tlkDepartIds);

    /**
     * 查询部门
     *
     * @param tlkDepartId 部门ID
     * @return 部门
     */
    ComDepart selectComDepartByTlkId(String tlkDepartId);

    /**
     * 查询部门列表
     *
     * @param comDepart 部门
     * @return 部门集合
     */
    List<ComDepart> selectComDepartList(ComDepart comDepart);

    /**
     * 删除部门
     *
     * @param departId 部门ID
     * @return 结果
     */
    int deleteComDepartById(Long departId);

    /**
     * 批量删除部门
     *
     * @param departIds 需要删除的数据ID
     * @return 结果
     */
    int deleteComDepartByIds(String[] departIds);

    /****
     * 保存
     * @param comDepart
     * @return
     */
    int save(ComDepart comDepart);

    /****
     * 选择修改
     * @param comDepart
     * @return
     */
    int updateSelective(ComDepart comDepart);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ComDepart> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComDepart> findByBatchId(@Param("list") List<ComDepart> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComDepart> findByBatchTlkId(@Param("list") List<ComDepart> list);

    /**
     * 获取企业的部门列表
     *
     * @param comId
     * @return
     * by llc 2019-07-16
     */
    List<OrgTreeDto> getDepartList(@Param(value = "comId") Long comId);

    /**
     * 获取部门树型 考勤打卡使用(有数据权限)
     *
     * @param comDepartDto 当前用户ID
     * @return
     */
    List<ComDepartTreeDto> getTreeDepartForAttend(ComDepartDto comDepartDto);

    /**
     * 获取部门(部门总人数)树型(有数据权限)
     *
     * @param comId
     *            公司ID
     *            当前用户ID
     * @return
     */
    List<Map> getTreeDepart(@Param(value = "comId") Long comId);

    /**
     * 获取部门(部门总人数)树型(无数据权限)
     *
     * @param comId
     *            公司ID
     * @return
     */
    List<Map> getTreeDepartNotDataAuth(@Param(value = "comId") Long comId);

    /**
     * 天翎部门上级id批量查询
     * @param list
     * @return
     */
    List<ComDepart> findByBatchTlkParentId(List<ComDepart> list);

    List<ComDepart> selectListByComId(Long comId);

    List<String> findByTlkIds(@Param("list") List<String> tlkDepartIds);
}
