package com.bcxin.platform.mapper.company;

import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.dto.company.ComDTO;

import java.util.List;
import java.util.Map;

/**
 * 企业基础信息Mapper接口
 *
 * @author lin
 * @date 2021-04-09
 */
public interface ComBaseInfoMapper{

    /**
     * 查询企业基础信息
     *
     * @param comId 企业基础信息ID
     * @return 企业基础信息
     */
    ComBaseInfo selectComBaseInfoById(Long comId);

    /**
     * 查询企业基础信息
     *
     * @param tlkComId 企业基础信息ID
     * @return 企业基础信息
     */
    ComBaseInfo selectComBaseInfoByTlkId(String tlkComId);

    /**
     * 查询企业基础信息列表
     *
     * @param comBaseInfo 企业基础信息
     * @return 企业基础信息集合
     */
    List<ComBaseInfo> selectComBaseInfoList(ComBaseInfo comBaseInfo);

    /**
     * 新增企业基础信息
     *
     * @param comBaseInfo 企业基础信息
     * @return 结果
     */
    int insertComBaseInfo(ComBaseInfo comBaseInfo);

    /**
     * 修改企业基础信息
     *
     * @param comBaseInfo 企业基础信息
     * @return 结果
     */
    int updateComBaseInfo(ComBaseInfo comBaseInfo);

    /**
     * 删除企业基础信息
     *
     * @param comId 企业基础信息ID
     * @return 结果
     */
    int deleteComBaseInfoById(Long comId);

    /**
     * 批量删除企业基础信息
     *
     * @param comIds 需要删除的数据ID
     * @return 结果
     */
    int deleteComBaseInfoByIds(String[] comIds);

    /**
     * <b> 根据企业id查询注册省 </b>
     * @author ZXF
     * @create 2019/04/22 0022 16:54
     * @version
     * @注意事项 </b>
     */
    String getProvinceByID(Long comId);

    /**
     * <b> 根据企业id查询企业名称 </b>
     * @author ZXF
     * @create 2019/12/30 0030 10:41
     * @version
     * @注意事项 </b>
     */
    String getComNameByID(Long comId);

    ComDTO selectDetialByID(Long comId);

    /**
     * 查询所属企业下拉信息
     *
     * @param p
     * @return
     */
    List<Map> queryCompanyCombobox();
}
