package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendSchedulConflict;
import com.bcxin.platform.dto.app.AppAttendSchedulConflictDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤排班冲突Mapper接口
 * 
 * @author lin
 * @date 2022-02-14
 */
public interface AttendSchedulConflictMapper{

    /**
     * 查询考勤排班冲突
     * 
     * @param id 考勤排班冲突ID
     * @return 考勤排班冲突
     */
    AttendSchedulConflict findById(Long id);

    /**
     * 查询考勤排班冲突列表
     * 
     * @param attendSchedulConflict 考勤排班冲突
     * @return 考勤排班冲突集合
     */
    List<AttendSchedulConflict> selectList(AttendSchedulConflict attendSchedulConflict);
    /**
     * 根据考勤套id查询考勤排班冲突列表
     *
     * @param attendId 考勤套id
     * @return 考勤排班冲突集合
     */
    List<AppAttendSchedulConflictDto> findByAttenId(Long attendId);

    /**
     * 删除考勤排班冲突
     * 
     * @param id 考勤排班冲突ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤排班冲突
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendSchedulConflict
     * @return
     */
    int save(AttendSchedulConflict attendSchedulConflict);

    /****
     * 选择修改
     * @param attendSchedulConflict
     * @return
     */
    int updateSelective(AttendSchedulConflict attendSchedulConflict);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendSchedulConflict> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendSchedulConflict> findByBatchId(@Param("list") List<AttendSchedulConflict> list);

    int coverSchedul(AttendSchedulConflict attendSchedulConflict);
    int coverConflict(AttendSchedulConflict attendSchedulConflict);
}
