package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendPer;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendPerDto;
import com.bcxin.platform.dto.attend.AttendPerDto;
import com.bcxin.platform.dto.attend.AttendSchedulDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤人员Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendPerMapper{

    /**
     * 查询考勤人员
     * 
     * @param id 考勤人员ID
     * @return 考勤人员
     */
    AttendPer findById(Long id);

    /**
     * 查询考勤人员列表
     * 
     * @param attendPer 考勤人员
     * @return 考勤人员集合
     */
    List<AttendPerDto> selectList(AttendPerDto attendPer);

    /**
     * 删除考勤人员
     * 
     * @param id 考勤人员ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤人员
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    List<AttendPer> findByPerIds(AttendSchedulDto attendSchedulDto);

    /****
     * 保存
     * @param attendPer
     * @return
     */
    int save(AttendPer attendPer);

    /****
     * 选择修改
     * @param attendPer
     * @return
     */
    int updateSelective(AttendPer attendPer);

    /**
     * 批量保存
     * @param list
     */
    int saveBatch(@Param("list") List<AttendPer> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendPer> findByBatchId(@Param("list") List<AttendPer> list);

    List<PerBaseInfo> findByBatchPerId(@Param("list") List<AttendPer> list);

    AttendPer findByPerId(Long perId);

    List<PerBaseInfo> getDepartPersonList(AttendPerDto searchDto);

    void removeSchedul(AttendPer dbAttendPer);

    List<AppAttendPerDto> selectListForPer(AppAttendPerDto perDto);

    List<AppAttendPerDto> getUnSchedulPersonList(AppAttendPerDto perDto);

    int deleteByPerIds(AppAttendPerDto attendPerDto);

    List<AttendPer> findByAttendId(Long attendId);
}
