package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendCalendar;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤打卡日历套Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendCalendarMapper{

    /**
     * 查询考勤打卡日历套
     * 
     * @param id 考勤打卡日历套ID
     * @return 考勤打卡日历套
     */
    AttendCalendar findById(Long id);

    /**
     * 查询考勤打卡日历套列表
     * 
     * @param attendCalendar 考勤打卡日历套
     * @return 考勤打卡日历套集合
     */
    List<AttendCalendar> selectList(AttendCalendar attendCalendar);

    /**
     * 删除考勤打卡日历套
     * 
     * @param id 考勤打卡日历套ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤打卡日历套
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendCalendar
     * @return
     */
    int save(AttendCalendar attendCalendar);

    /****
     * 选择修改
     * @param attendCalendar
     * @return
     */
    int updateSelective(AttendCalendar attendCalendar);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendCalendar> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendCalendar> findByBatchId(@Param("list") List<AttendCalendar> list);

    /**
     * 根据名称查询
     * @param calendarName
     * @return
     */
    AttendCalendar findByName(String calendarName);
}
