package com.bcxin.platform.dto.meeting;

import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <b> VMR信息映射dto </b>
 *
 * @author ZXF
 * @create 2020/02/19 0019 10:49
 * @注意事项 </b>
 */
@Data
public class ModVmrDto extends PerHuaweiMeetMatch {

    /**
     * 云会议室唯一标识
     */
    @ApiModelProperty(value = "云会议室唯一标识")
    private String id;


    /**
     * 云会议室名称
     */
    @ApiModelProperty(value = "云会议室名称")
    private String vmrName;

    /**
     * 主席密码
     */
    @ApiModelProperty(value = "主席密码")
    private String chairPwd;

    /**
     * 来宾密码
     */
    @ApiModelProperty(value = "来宾密码")
    private String gustPwd;

    /**
     * 用户账号
     */
    @ApiModelProperty(value = "用户账号")
    private String account;

    /**
     * 云会议室唯一ID列表，多个逗号隔开
     */
    @ApiModelProperty(value = "云会议室唯一ID列表")
    private String vmrIdList;

    /**
     * 搜索条件。支持云会议室名称、ID模糊搜索
     */
    @ApiModelProperty(value = "搜索条件。支持云会议室名称、ID模糊搜索")
    private String searchKey;

    /**
     * 查询vmr的类型,为null则查询所有.0：个人云会议室，1：专用云会议室
     */
    @ApiModelProperty(value = "查询vmr的类型")
    private String specialVmr;

    /**
     * 是否允许来宾先入会
     */
    @ApiModelProperty(value = "是否允许来宾先入会")
    private Boolean allowGustFirst = false;
    //boolean的字符串用于接收前端的值
    private String allowGustFirstStr;


    /**
     * 云会议室被使用后是否通知会议室所有者
     */
    @ApiModelProperty(value = "云会议室被使用后是否通知会议室所有者")
    private Boolean gustFirstNotice = false;

    private String gustFirstNoticeStr;

    public void setBool() {
        this.allowGustFirst = BOOL_STR.equals(this.allowGustFirstStr) ? true : false;
        this.gustFirstNotice = BOOL_STR.equals(this.gustFirstNoticeStr) ? true : false;
    }

    private static final String BOOL_STR = "1";//boolean为true的字符串
}
