package com.bcxin.platform.domain.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业钱包变更明细
 *
 * @author llc
 * @date 2019-09-10
 */
@Data
@TableName("com_wallet_change_detail")
public class ComWalletChangeDetail extends BaseEntity<ComWalletChangeDetail> {
    /**
     * 企业钱包变更明细ID
     */
    @ApiModelProperty(value = "企业钱包变更明细ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comWalletChangeDetailId;

    /**
     * 变更项目
     */
    private String changeCode;

    /**
     * 变更项目中文描述
     */
    private String changeCodeCn;

    /**
     * 变更项目所在表
     */
    private String changeCodeTable;

    /**
     * 变更项目所在表类型
     */
    private String tableType;

    /**
     * 变更前信息
     */
    private String changeBeforeInfo;

    /**
     * 变更前展示信息
     */
    private String changeBeforeShowInfo;

    /**
     * 变更后信息
     */
    private String changeAfterInfo;

    /**
     * 变更后展示信息
     */
    private String changeAfterShowInfo;


    /**
     * 企业钱包变更事件ID
     */
    @ApiModelProperty(value = "企业钱包变更事件ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comWalletChangeEventId;

}