package com.bcxin.platform.domain.product;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;


/**
 * <b> 公安华为云会议映射 </b>
 * @author ZXF
 * @create 2020/05/22 0022 15:30
 * @version
 * @注意事项 </b>
 */
@TableName("police_huawei_meet_match")
@Data
public class PoliceHuaweiMeetMatch extends BaseEntity<PoliceHuaweiMeetMatch> {

    /** 公安ID */
    @ApiModelProperty(value = "公安ID")
    private Long policeId;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用")
    private String isActive;

    /**
     * 华为云会议企业ID
     */
    @NotNull(message = "华为云会议企业ID")
    @ApiModelProperty(value = "华为云会议企业ID")
    private Long huaweiComId;

    /**
     * 华为云会议管理员用户
     */
    @ApiModelProperty(value = "华为云会议管理员用户")
    private String huaweiManageUserName;


    /**
     * 华为云会议管理员密码
     */
    @ApiModelProperty(value = "华为云会议管理员密码")
    private String huaweiManagePassWord;

}