package com.bcxin.platform.domain.meeting;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;


/**
 * 企业华为云会议映射
 *
 * @author llc
 * @date 2019-12-11
 */
@TableName("com_huawei_meet_match")
@Data
public class ComHuaweiMeetMatch extends BaseEntity<ComHuaweiMeetMatch> {

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用")
    private String isActive;

    /**
     * 华为云会议企业ID
     */
    @NotNull(message = "华为云会议企业ID")
    @ApiModelProperty(value = "华为云会议企业ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long huaweiComId;

    /**
     * 华为云会议管理员用户
     */
    @ApiModelProperty(value = "华为云会议管理员用户")
    private String huaweiManageUserName;


    /**
     * 华为云会议管理员密码
     */
    @ApiModelProperty(value = "华为云会议管理员密码")
    private String huaweiManagePassWord;

}