package com.bcxin.platform.domain.grant;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业渤海发放操作记录
 * 
 * @author llc
 * @date 2020-08-13
 */
@Data
@TableName("com_bh_grant_oper_record")
public class ComBhGrantOperRecord extends BaseEntity<ComBhGrantOperRecord> {

	/** 企业渤海发放操作记录ID */
	@ApiModelProperty(value = "企业渤海发放操作记录ID")
	private Long comBhGrantOperRecordId;

	/** 操作发放功能类型 */
	@ApiModelProperty(value = "操作发放功能类型")
	private String operGrantFuncType;

	/** 操作结果 */
	@ApiModelProperty(value = "操作结果")
	private String operResult;

	/** 企业渤海发放ID */
	@ApiModelProperty(value = "企业渤海发放ID")
	private Long comBhGrantId;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComBhGrantOperRecordId() {
		return comBhGrantOperRecordId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComBhGrantId() {
		return comBhGrantId;
	}

}