package com.bcxin.platform.domain.company;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 部门
 *
 * @author zhangye
 * @since 2017-12-22 10:37:18
 */
@TableName("com_depart")
@DisMultiTenancy
@Data
public class ComDepart extends BaseEntity<ComDepart> {
	private static final long serialVersionUID = 180159436L;
	/**
	 * 部门ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ApiModelProperty(value = "部门ID")
	private Long departId;

	/**
	 * 部门名称
	 */
	@ApiModelProperty(value = "部门名称")
	private String departName;

	/**
	 * 排序
	 */
	@ApiModelProperty(value = "排序")
	private Integer seq ;

	/**
	 * 部门树查询代码
	 */
	@ApiModelProperty(value = "部门树查询代码")
	private String departTreeCode;

	/**
	 * 上级部门ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ApiModelProperty(value = "上级部门ID")
	private Long parentDepartId;

	/**
	 * 企业ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	@ApiModelProperty(value = "企业ID")
	private Long comId;

	/**
	 * V5部门id
	 */
	@ApiModelProperty(value = "V5部门id")
	private String tlkDepartId;

	/**
	 * V5上线部门id
	 */
	@ApiModelProperty(value = "V5上线部门id")
	private String tlkParentDepartId;
}