package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 考勤人员对象 tb_attend_per
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendPer extends BaseEntity implements Cloneable{

    private static final long serialVersionUID = 1L;

    /** 考勤人员ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 人员ID */
    @Excel(name = "人员ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="人员ID不能为空", groups = {UpdateGroup.class})
    private Long perId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="人员ID不能为空", groups = {AddGroup.class})
    private Long[] perIds;

    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="考勤套ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long attendId;

    /** 公司ID */
    @Excel(name = "公司ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    //@NotNull(message="公司ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long comId;

    //自定义类实现自己的clone()方法
    @Override
    public AttendPer clone() throws CloneNotSupportedException {
        //通过super.clone()实现clone()方法
        return (AttendPer) super.clone();
    }

}
