package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤打卡记录对象 tb_attend_clock
 * 
 * @author lin
 * @date 2021-08-27
 */
@Data
public class AttendClock extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 排班ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="排班ID不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long schedulDetailId;

    @Excel(name = "班次类型 1计时班次 2 计次班次")
    @NotBlank(message="班次类型不能为空", groups = {AddGroup.class})
    private String shiftType;

    /** 上班打卡时间 */
    @Excel(name = "上班打卡时间")
    @NotBlank(message="上班打卡时间不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String clockStart;

    /** 下班打卡时间 */
    @Excel(name = "下班打卡时间")
    @NotBlank(message="下班打卡时间不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String clockEnd;

    /** 早退分钟数 */
    @Excel(name = "早退分钟数")
    private Integer leaveEarly;

    /** 迟到分钟数 */
    @Excel(name = "迟到分钟数")
    private Integer lateMin;

    /** 实际出勤时数 */
    @Excel(name = "实际出勤时数")
    private Double workHour;

    /** 旷工时数 */
    @Excel(name = "旷工时数")
    private Double absenteeism;

    /** 漏卡次数 */
    @Excel(name = "漏卡次数")
    private Integer missCard;

    /** 请假时数 */
    @Excel(name = "请假时数")
    private Double leaveHour;

    /** 公出时数 */
    @Excel(name = "公出时数")
    private Double businessOut;

    /** 出差时数 */
    @Excel(name = "出差时数")
    private Double businessTrip;

    /** 数据来源 1打卡2补卡*/
    @Excel(name = "数据来源")
    private String clockSource;

    /** 打卡状态 1正常2缺卡3迟到4早退5缺勤6补卡11请假21上班缺卡22下班缺卡34迟到早退61上班补卡62下班补卡*/
    private String clockStatus;

    /** 打卡地址 */
    private String address;

    /** 打卡wifi名称 */
    private String wifiName;

    /** 补卡原因 */
    @Excel(name = "补卡原因")
    private String reason;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    private AttendSchedulDetail schedulDetail;

}
