package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤打卡日历套-日历-休息日对象 tb_attend_calendar_rest_detail
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendCalendarRestDetail extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 假日ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 日历类型 */
    @Excel(name = "日历类型")
    @NotBlank(message="日历类型不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String calendarType;

    /** 日期 */
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    @NotBlank(message="日期不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private String restDate;

    /** 日历ID */
    @Excel(name = "日历ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="日历ID不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private Long restId;

    /** 日历套ID */
    @Excel(name = "日历套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="日历套ID不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private Long calendarId;

}
