package com.bcxin.platform.config;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.spring.SpringUtils;
import com.bcxin.platform.dto.oauth.AccessToken;
import com.bcxin.platform.service.oauth.OAuthService;
import com.bcxin.platform.util.http.ParameterRequestWrapper;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

/**
 * V5鉴权拦截器
 *
 * @author zhangye
 * @version 1.0
 */
public class V5AccessControlFilter implements Filter {

    protected final Logger logger = LoggerFactory.getLogger(V5AccessControlFilter.class);

    @Override
    public void init(FilterConfig config) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        logger.error("request url:"+request.getRequestURL().toString());
        logger.error("request Params:"+ JSONObject.toJSONString(request.getParameterMap()));

        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers",
                "x-requested-with,content-type,Content-type,authorization,x-csrf-token,access_token,userV5Token");
        response.setHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        String access_token = request.getHeader("access_token");
        String userV5TokenStr = request.getHeader("userV5Token");
        boolean userV5Token = false;
        if ("1".equals(userV5TokenStr)) {
            userV5Token = true;
        }
        logger.error("request access_token:"+access_token);
        logger.error("request userV5Token:"+userV5Token);

        if (StringUtils.isNotEmpty(access_token)) {
            OAuthService oAuthService = SpringUtils.getBean(OAuthService.class);
            if (oAuthService != null) {
                AccessToken accessToken = oAuthService.getAccessToken(access_token,userV5Token);
                    if (accessToken != null) {
                        request.setAttribute("createBy", accessToken.getPerId());
                        request.setAttribute("updateBy", accessToken.getPerId());
                        request.setAttribute("comId", accessToken.getComId());
                        request.setAttribute("perId", accessToken.getPerId());
                        request.setAttribute("createName", accessToken.getName());
                        request.setAttribute("updateName", accessToken.getName());
                        request.setAttribute("domainAdmin", accessToken.isDomainAdmin());
                        request.setAttribute("adminOrgIds", accessToken.getAdminOrgIds());
                        Map<String, Object> paramter = new HashMap<String, Object>();

                        if (StrUtil.isEmpty(request.getParameter("comId"))) {
                            paramter.put("comId", accessToken.getComId());
                        }

                        //if(StrUtil.isEmpty(request.getParameter("perId"))){
                        //paramter.put("perId", accessToken.getPerId());
                        paramter.put("createBy", accessToken.getPerId());
                        paramter.put("updateBy", accessToken.getPerId());
                        paramter.put("createName", accessToken.getName());
                        paramter.put("updateName", accessToken.getName());
                        paramter.put("domainAdmin", accessToken.isDomainAdmin());
                        paramter.put("adminOrgIds", accessToken.getAdminOrgIds());
                        //}

                        ParameterRequestWrapper wrapper = new ParameterRequestWrapper(request, paramter);
                        filterChain.doFilter(wrapper, response);
                        return;
                    } else {
                        Result result = Result.tokenExpired("用户登陆超时或者未登陆").setBack(request);
                        ObjectMapper mapper = new ObjectMapper();
                        PrintWriter out = response.getWriter();
                        out.print(mapper.writeValueAsString(result));
                        out.close();
                        return;
                    }
            }
        }else{
            Result result = Result.tokenExpired("access_token缺失").setBack(request);
            ObjectMapper mapper = new ObjectMapper();
            PrintWriter out = response.getWriter();
            out.print(mapper.writeValueAsString(result));
            out.close();
            return;
        }
        filterChain.doFilter(request, response);
    }

    @Override
    public void destroy() {

    }
}
