package com.bcxin.obpm.service.impl;

import java.util.List;
import org.springframework.stereotype.Service;
import com.bcxin.obpm.mapper.ObpmUserMapper;
import com.bcxin.obpm.domain.ObpmUser;
import com.bcxin.obpm.service.ObpmUserService;

import javax.annotation.Resource;

/**
 * v5用户Service业务层处理
 * 
 * @author lin
 * @date 2021-06-06
 */
@Service
public class ObpmUserServiceImpl implements ObpmUserService{

    @Resource
    private ObpmUserMapper obpmUserMapper;

    /**
     * 查询v5用户
     * 
     * @param ID v5用户ID
     * @return v5用户
     */
    @Override
    public ObpmUser selectObpmUserById(String ID){
        return obpmUserMapper.selectObpmUserById(ID);
    }

    /**
     * 查询v5用户列表
     * 
     * @param tlkComId v5公司id
     * @return v5用户
     */
    @Override
    public List<ObpmUser> selectObpmUserList(String tlkComId){
        return obpmUserMapper.selectObpmUserList(tlkComId);
    }

}
