/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.product.impl;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.product.ConfigProductBuyMode;
import com.bcxin.platform.dto.product.ConfigProductInfoDto;
import com.bcxin.platform.dto.product.ConfigProductTypeDto;
import com.bcxin.platform.dto.product.ProductQueryDto;
import com.bcxin.platform.mapper.product.ConfigProductMapper;
import com.bcxin.platform.service.product.ConfigProductService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ConfigProductServiceImpl
implements ConfigProductService {
    @Resource
    private ConfigProductMapper configProductMapper;

    @Override
    public Result getProductList(ProductQueryDto dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getProductCategoryType())) {
            return Result.fail((String)"\u4ea7\u54c1\u8303\u7574\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getProductServiceType())) {
            return Result.fail((String)"\u4ea7\u54c1\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ConfigProductTypeDto> productTypeList = this.configProductMapper.getProductTypeList(dto.getProductCategoryType(), dto.getProductServiceType());
        List<Object> productInfoList = new ArrayList();
        if (productTypeList != null && productTypeList.size() > 0) {
            ArrayList<String> productTypeStrList = new ArrayList<String>();
            for (ConfigProductTypeDto configProductTypeDto : productTypeList) {
                productTypeStrList.add(configProductTypeDto.getProductType());
            }
            productInfoList = this.configProductMapper.getgProductInfoByTypeList(productTypeStrList);
        }
        List<Object> productBuyModeList = new ArrayList();
        if (productInfoList != null && productInfoList.size() > 0) {
            ArrayList<String> productIdList = new ArrayList<String>();
            for (ConfigProductInfoDto configProductInfoDto : productInfoList) {
                productIdList.add(configProductInfoDto.getProductId());
            }
            productBuyModeList = this.configProductMapper.getProductBuyModeByIdList(productIdList);
        }
        if (productBuyModeList != null && productBuyModeList.size() > 0) {
            for (ConfigProductInfoDto configProductInfoDto : productInfoList) {
                ArrayList<ConfigProductBuyMode> arrayList = new ArrayList<ConfigProductBuyMode>();
                for (ConfigProductBuyMode configProductBuyMode : productBuyModeList) {
                    if (!configProductBuyMode.getProductId().equals(configProductInfoDto.getProductId())) continue;
                    arrayList.add(configProductBuyMode);
                }
                configProductInfoDto.setProductBuyModeList(arrayList);
            }
        }
        if (productInfoList != null && productInfoList.size() > 0) {
            for (ConfigProductTypeDto configProductTypeDto : productTypeList) {
                ArrayList<ConfigProductInfoDto> arrayList = new ArrayList<ConfigProductInfoDto>();
                for (ConfigProductInfoDto configProductInfoDto : productInfoList) {
                    if (!configProductInfoDto.getProductType().equals(configProductTypeDto.getProductType())) continue;
                    arrayList.add(configProductInfoDto);
                }
                configProductTypeDto.setProductInfoList(arrayList);
            }
        }
        return Result.success((String)"", productTypeList);
    }
}

