/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.dataSync;

import cn.hutool.core.util.StrUtil;
import com.bcxin.obpm.domain.ObpmCompany;
import com.bcxin.obpm.domain.ObpmDepartment;
import com.bcxin.obpm.domain.ObpmUser;
import com.bcxin.obpm.domain.UserDepartment;
import com.bcxin.obpm.service.ObpmCompanyService;
import com.bcxin.obpm.service.ObpmDepartmentService;
import com.bcxin.obpm.service.ObpmUserService;
import com.bcxin.obpm.service.UserDepartmentService;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.IdcardUtils;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.service.company.ComBaseInfoService;
import com.bcxin.platform.service.company.ComDepartService;
import com.bcxin.platform.service.company.PerBaseInfoService;
import com.bcxin.platform.service.company.PerOrgRelationService;
import com.bcxin.platform.service.dataSync.IObpmDataSyncService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ObpmDataSyncServiceImpl
implements IObpmDataSyncService {
    @Resource
    private ObpmCompanyService obpmCompanyService;
    @Resource
    private ObpmUserService obpmUserService;
    @Resource
    private ObpmDepartmentService obpmDepartmentService;
    @Resource
    private UserDepartmentService userDepartmentService;
    @Resource
    private ComBaseInfoService comBaseInfoService;
    @Autowired
    private ComDepartService comDepartService;
    @Autowired
    private PerBaseInfoService perBaseInfoService;
    @Autowired
    private PerOrgRelationService perOrgRelationService;
    @Resource
    private IdWorker idWorker;

    @Override
    public void getV5InfoByTlkPerId(String tlkPerId) {
        ObpmUser obpmUser = this.obpmUserService.selectObpmUserById(tlkPerId);
        ObpmCompany obpmCompany = this.obpmCompanyService.selectObpmCompanyById(obpmUser.getDOMAINID());
        ComBaseInfo comBaseInfo = this.comBaseInfoService.selectComBaseInfoByTlkId(obpmCompany.getID());
        if (comBaseInfo == null) {
            comBaseInfo = new ComBaseInfo();
            comBaseInfo.setComId(this.idWorker.nextId());
            comBaseInfo.setIsDelete("0");
            comBaseInfo.setTlkComId(obpmCompany.getID());
            comBaseInfo.setComName(obpmCompany.getNAME());
            comBaseInfo.setRegProvince(430000);
            comBaseInfo.setRegCity(430100);
            comBaseInfo.setRegArea(430101);
            comBaseInfo.setRegAddress(obpmCompany.getREGISTERADDRESS());
            comBaseInfo.setComTreeCode(comBaseInfo.getComId().toString());
            comBaseInfo.setComCerNo(obpmCompany.getFIELD11());
            comBaseInfo.setComType("9");
            comBaseInfo.setComCerType("2");
            comBaseInfo.setIndustryType("0102");
            comBaseInfo.setInstitutionType("01");
            this.comBaseInfoService.insertComBaseInfo(comBaseInfo);
        }
        PerBaseInfo perBaseInfo = new PerBaseInfo();
        perBaseInfo.setPerId(this.idWorker.nextId());
        perBaseInfo.setIdCardNo(obpmUser.getFIELD12());
        perBaseInfo.setIdCardType("1");
        perBaseInfo.setIsIncumbency("1");
        perBaseInfo.setIsDelete("0");
        perBaseInfo.setName(obpmUser.getNAME());
        perBaseInfo.setMobilePhone(obpmUser.getLOGINNO());
        perBaseInfo.setTlkPerId(obpmUser.getID());
        perBaseInfo.setComId(comBaseInfo.getComId());
        try {
            perBaseInfo.setBirthDay(IdcardUtils.getBirthDayByIdCard((String)perBaseInfo.getIdCardNo()));
            perBaseInfo.setSex(IdcardUtils.getGenderByIdCard((String)perBaseInfo.getIdCardNo()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        perBaseInfo.setPerType("010001");
        this.perBaseInfoService.insertPerBaseInfo(perBaseInfo);
        List<UserDepartment> dbUserDepartmentList = this.userDepartmentService.selectUserDepartmentByUserId(tlkPerId);
        ArrayList<PerOrgRelation> relationList = new ArrayList<PerOrgRelation>();
        if (dbUserDepartmentList.size() > 0) {
            List<ObpmDepartment> departmentList = this.obpmDepartmentService.selectObpmDepartmentList(obpmCompany.getID());
            List<ComDepart> dbComDepartList = this.comDepartService.selectListByComId(comBaseInfo.getComId());
            Map departMap = dbComDepartList.stream().collect(Collectors.toMap(ComDepart::getTlkDepartId, Function.identity()));
            ArrayList<ComDepart> comDepartList = new ArrayList<ComDepart>();
            for (ObpmDepartment obpmDepartment : departmentList) {
                ComDepart comDepart = (ComDepart)departMap.get(obpmDepartment.getID());
                if (comDepart != null) continue;
                comDepart = new ComDepart();
                comDepart.setDepartId(this.idWorker.nextId());
                comDepart.setIsDelete("0");
                comDepart.setComId(comBaseInfo.getComId());
                comDepart.setTlkDepartId(obpmDepartment.getID());
                comDepart.setSeq(obpmDepartment.getLEVELS().intValue());
                comDepart.setDepartName(obpmDepartment.getNAME());
                if (StrUtil.isNotEmpty((CharSequence)obpmDepartment.getSUPERIOR())) {
                    ComDepart parentDepart = (ComDepart)departMap.get(obpmDepartment.getSUPERIOR());
                    if (parentDepart != null) {
                        comDepart.setParentDepartId(parentDepart.getDepartId());
                        comDepart.setDepartTreeCode(parentDepart.getDepartTreeCode() + comDepart.getDepartId() + "-");
                    } else {
                        System.out.println("\u4e0a\u7ea7\u90e8\u95e8\u672a\u540c\u6b65");
                    }
                } else {
                    comDepart.setParentDepartId(-1L);
                    comDepart.setDepartTreeCode(comDepart.getDepartId() + "-");
                }
                comDepartList.add(comDepart);
                departMap.put(comDepart.getTlkDepartId(), comDepart);
            }
            if (comDepartList.size() > 0) {
                this.comDepartService.saveBatch(comDepartList);
            }
            for (UserDepartment userDepartment : dbUserDepartmentList) {
                PerOrgRelation perOrgRelation = new PerOrgRelation();
                perOrgRelation.setPerOrgRelationId(this.idWorker.nextId());
                perOrgRelation.setComId(comBaseInfo.getComId());
                perOrgRelation.setPerId(perBaseInfo.getPerId());
                perOrgRelation.setEntryDate(perBaseInfo.getCreateTime());
                perOrgRelation.setTlkRelationId(userDepartment.getId());
                ComDepart comDepart = (ComDepart)departMap.get(userDepartment.getDepartmentId());
                perOrgRelation.setOrgId(comDepart.getDepartId());
                perOrgRelation.setOrgType("2");
                relationList.add(perOrgRelation);
            }
        } else {
            PerOrgRelation perOrgRelation = new PerOrgRelation();
            perOrgRelation.setPerOrgRelationId(this.idWorker.nextId());
            perOrgRelation.setOrgId(comBaseInfo.getComId());
            perOrgRelation.setComId(comBaseInfo.getComId());
            perOrgRelation.setPerId(perBaseInfo.getPerId());
            perOrgRelation.setOrgType("1");
            perOrgRelation.setTlkRelationId(null);
            relationList.add(perOrgRelation);
        }
        if (relationList.size() > 0) {
            this.perOrgRelationService.saveBatch(relationList);
        }
    }
}

