/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.bbd;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.bean.ObjectUtils;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.log.SysInterfaceLog;
import com.bcxin.platform.dto.wallet.ComWalletTransferDTO;
import com.bcxin.platform.mapper.common.SysPlatMapper;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.log.SysInterfaceLogMapper;
import com.bcxin.platform.service.bbd.BbdTestService;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.util.HttpUtils;
import com.bcxin.platform.util.ResultJson;
import com.bcxin.platform.util.ThreadPool;
import com.bcxin.platform.util.constants.PlatConst;
import com.bcxin.platform.util.v5.BcxinHttpUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class BbdTestServiceImpl
implements BbdTestService {
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private TaskCacheService taskCacheService;
    @Resource
    private SysPlatMapper sysPlatMapper;
    @Resource
    private SysInterfaceLogMapper sysInterfaceLogMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public String bbdGetDffSubsidyList(ComWalletTransferDTO dto) {
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
        String openSubstation = this.commonService.getSystemConfig("OPEN_SUBSTATION");
        String configURL = StringUtils.isNotEmpty((String)openSubstation) && openSubstation.equals("1") ? this.commonService.getSystemConfig("TRACK_DEFAULT") : this.commonService.getSystemConfig("TRACK_" + comBaseInfo.getRegProvince());
        if (StringUtils.isEmpty((String)configURL) || configURL.equalsIgnoreCase("null")) {
            return null;
        }
        String bbdToken = this.taskCacheService.getBbdAccessToken(comBaseInfo.getComId(), configURL);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sid", bbdToken);
        paramMap.put("pageNumber", dto.getPageNumber().toString());
        paramMap.put("pageSize", dto.getPageSize().toString());
        paramMap.put("order", "desc");
        paramMap.put("subsidyCerType", ObjectUtils.equals((Object)dto.getSubsidyType(), (Object)"1") ? "02" : "01");
        paramMap.put("batchName", dto.getBatchName());
        paramMap.put("companynameBatch", dto.getSubsidyObject());
        paramMap.put("applyStartTime", dto.getStartTime());
        paramMap.put("applyEndTime", dto.getEndTime());
        String resultStr = HttpUtil.post((String)(configURL + "/gradeSubsidyBatch/searchForPage.json"), paramMap);
        return resultStr;
    }

    @Override
    public String bbdGetBbdSubsidyPageUrl(ComWalletTransferDTO dto) {
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
        String platUrl = this.sysPlatMapper.getPlatUrl("bbd", comBaseInfo.getRegProvince());
        String bbdSubsidyPageUrl = platUrl + "/gradeSubsidyBatch/detail/index.do";
        return bbdSubsidyPageUrl;
    }

    @Override
    public Result bbdSyncSubsidyGrantStatus(ComWalletTransferDTO dto) {
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(dto.getComId());
        String openSubstation = this.commonService.getSystemConfig("OPEN_SUBSTATION");
        String configURL = StringUtils.isNotEmpty((String)openSubstation) && openSubstation.equals("1") ? this.commonService.getSystemConfig("TRACK_DEFAULT") : this.commonService.getSystemConfig("TRACK_" + comBaseInfo.getRegProvince());
        String bbdToken = this.taskCacheService.getBbdAccessToken(comBaseInfo.getComId(), configURL);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sid", bbdToken);
        paramMap.put("id", dto.getBatchNo());
        SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
        Long interfaceLogId = this.idWorker.nextId();
        sysInterfaceLog.setInterfaceLogId(interfaceLogId);
        sysInterfaceLog.setCreateTime(new Date());
        sysInterfaceLog.setCreateBy(dto.getCreateBy());
        sysInterfaceLog.setInterfaceType("1501");
        sysInterfaceLog.setStartTime(new Date());
        sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
        sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
        sysInterfaceLog.setParameters(JSON.toJSONString(paramMap));
        String url = configURL + "/gradeSubsidyBatch/updateGrantState.json";
        sysInterfaceLog.setUrl(url);
        Result result = new Result();
        try {
            result = BbdTestServiceImpl.syncSubsidyGrantStatus(paramMap, url);
            if (result != null && "0".equals(result.getRetType())) {
                sysInterfaceLog.setInterfaceExecStatus("1");
            } else {
                sysInterfaceLog.setInterfaceExecStatus("0");
                sysInterfaceLog.setResult(result.getMsg());
            }
        }
        catch (Exception e) {
            sysInterfaceLog.setInterfaceExecStatus("0");
            sysInterfaceLog.setResult("\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        sysInterfaceLog.setEndTime(new Date());
        this.sysInterfaceLogMapper.insert(sysInterfaceLog);
        return result;
    }

    @Override
    public void tlSyncPerPolicyStatus(final List<Map> list) {
        if (list.size() < 1) {
            return;
        }
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                String url = BbdTestServiceImpl.this.commonService.getSystemConfig("BDP_URL");
                Map<String, String> map = BbdTestServiceImpl.this.commonService.getConfigBdp("teemlink-blb-updateInsureStatus");
                if (map == null) {
                    return;
                }
                SysInterfaceLog sysInterfaceLog = new SysInterfaceLog();
                Long interfaceLogId = BbdTestServiceImpl.this.idWorker.nextId();
                sysInterfaceLog.setInterfaceLogId(interfaceLogId);
                sysInterfaceLog.setCreateTime(new Date());
                sysInterfaceLog.setInterfaceType("1300");
                sysInterfaceLog.setStartTime(new Date());
                sysInterfaceLog.setProvidePlatId(PlatConst.PLAT_BBD);
                sysInterfaceLog.setCallPlatId(PlatConst.PLAT_SAAS);
                sysInterfaceLog.setParameters(JSON.toJSONString((Object)list));
                sysInterfaceLog.setUrl(url);
                try {
                    String ret = BcxinHttpUtil.sendPostRequest(url, map, list);
                    if (StringUtils.isEmpty((String)ret)) {
                        sysInterfaceLog.setInterfaceExecStatus("0");
                        sysInterfaceLog.setResult("");
                    } else {
                        JSONObject json = JSONObject.parseObject((String)ret);
                        if ("200".equals(json.get((Object)"status"))) {
                            sysInterfaceLog.setInterfaceExecStatus("1");
                        } else {
                            sysInterfaceLog.setInterfaceExecStatus("0");
                            sysInterfaceLog.setResult("");
                        }
                    }
                }
                catch (Exception e) {
                    sysInterfaceLog.setInterfaceExecStatus("0");
                    sysInterfaceLog.setResult("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:" + e.getMessage());
                }
                sysInterfaceLog.setEndTime(new Date());
                BbdTestServiceImpl.this.sysInterfaceLogMapper.insert(sysInterfaceLog);
            }
        });
    }

    public static Result syncSubsidyGrantStatus(Map paramMap, String url) {
        ResultJson resultJson = HttpUtils.sendHttpMap(url, paramMap);
        if (resultJson != null && resultJson.isSuccessful()) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)resultJson.getData());
        }
        return Result.fail((String)resultJson.getMsg());
    }
}

